% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_spline_X.R
\name{reg_spline_X}
\alias{reg_spline_X}
\title{Make a design matrix for regression spline}
\usage{
reg_spline_X(x, xp, smooth, ...)
}
\arguments{
\item{x}{values of the predictor}

\item{xp}{values of the predictor for plotting the calibration curve}

\item{smooth}{spline to use (\code{rms::rcs}, \code{splines::ns}, \code{splines::bs} currently supported via 'rcs', 'ns', 'bs'). \code{smooth} = 'none' results in \code{x} as only predictor (i.e., no spline)}

\item{...}{additional arguments for specific splines ('nk' or 'knots' for 'rcs', 'df' or 'knots' for 'ns' or 'bs')}
}
\value{
a list containing
\itemize{
\item{\code{X} the design matrix for the data}
\item{\code{Xp} the design matrix for plotting}
}
}
\description{
Make a design matrix for regression spline
}
\examples{
x <- rnorm(100)
xp <- seq(min(x), max(x), length.out=50)
reg_spline_X(x = x, xp = xp, smooth="rcs", nk=6)
}
\keyword{internal}
