% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/between_within.R
\name{panel_calculations}
\alias{panel_calculations}
\alias{within_i}
\alias{between_i}
\title{Perform standard panel-data calculations}
\usage{
within_i(.var, .df = get(".", envir = parent.frame()),
  .fcn = function(x) mean(x, na.rm = TRUE), .i = NULL, .t = NULL,
  .uniqcheck = FALSE)

between_i(.var, .df = get(".", envir = parent.frame()),
  .fcn = function(x) mean(x, na.rm = TRUE), .i = NULL, .t = NULL,
  .uniqcheck = FALSE)
}
\arguments{
\item{.var}{Vector to be transformed}

\item{.df}{Data frame, pibble, or tibble (usually the data frame or tibble that contains \code{.var}) which contains the panel structure variables either listed in \code{.i} and \code{.t}, or earlier declared with \code{as_pibble()}. If \code{tlag} is called inside of a \code{dplyr} verb, this can be omitted and the data will be picked up automatically.}

\item{.fcn}{The function to be passed to \code{dplyr::summarize()}. \code{x - .fcn(x)} within \code{.i} is the within tranformation. \code{.fcn(x)} within \code{.i} minus \code{.fcn} overall is the between transformation. This will almost always be the default \code{.fcn = function(x) mean(x,na.rm=TRUE)}.}

\item{.i}{Quoted or unquoted variable(s) that identify the individual cases. Note that setting any one of \code{.i}, \code{.t}, or \code{.d} will override all three already applied to the data, and will return data that is \code{as_pibble()}d with all three, unless \code{.setpanel=FALSE}.}

\item{.t}{Quoted or unquoted variable with the single variable name indicating the time. \code{pmdplyr} accepts two kinds of time variables: numeric variables where a fixed distance \code{.d} will take you from one observation to the next, or, if \code{.d=0}, any standard variable type with an order. Consider using the \code{time_variable()} function to create the necessary variable if your data uses a \code{Date} variable for time.}

\item{.uniqcheck}{Logical parameter. Set to TRUE to always check whether \code{.i} and \code{.t} uniquely identify observations in the data. By default this is set to FALSE and the check is only performed once per session, and only if at least one of \code{.i}, \code{.t}, or \code{.d} is set.}
}
\description{
These functions perform the standard between and within transformations on panel data.
}
\details{
These functions do not take a \code{.d} argument because it is irrelevant here.
}
\examples{

data(SPrail)
# Calculate within- and between-route variation in price and add it to the data
SPrail <- SPrail \%>\%
  dplyr::mutate(
    within_route = within_i(price, .i = c(origin, destination)),
    between_route = between_i(price, .i = c(origin, destination))
  )
}
