% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_pmml.R
\name{save_pmml}
\alias{save_pmml}
\title{Save a pmml object as an external PMML file.}
\usage{
save_pmml(doc, name)
}
\arguments{
\item{doc}{The pmml model.}

\item{name}{The name of the external file where the PMML is to be saved.}
}
\description{
Save a pmml object to an external PMML file.
}
\examples{
\dontrun{
# Make a gbm model:
library(gbm)
data(audit)

mod <- gbm(Adjusted ~ .,
  data = audit[, -c(1, 4, 6, 9, 10, 11, 12)],
  n.trees = 3,
  interaction.depth = 4
)

# Export to PMML:
pmod <- pmml(mod)

# Save to an external file:
save_pmml(pmod, "GBMModel.pmml")
}

}
\author{
Tridivesh Jena
}
\keyword{interface}
