% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_pubmed_db.R
\name{modifyPubmedDb}
\alias{modifyPubmedDb}
\title{Create or update a PubMed database}
\usage{
modifyPubmedDb(
  localDir,
  dbname,
  dbtype = c("postgres", "mariadb", "mysql", "sqlite"),
  nFiles = Inf,
  retry = TRUE,
  nCitations = Inf,
  mode = c("create", "update"),
  ...
)
}
\arguments{
\item{localDir}{Directory in which to download the files from PubMed.}

\item{dbname}{Name of database.}

\item{dbtype}{Type of database, either 'postgres', 'mariadb', 'mysql', or
'sqlite'. Make sure to install the corresponding DBI driver package first:
RPostgres, RMariaDB (for both 'mariadb' and 'mysql'), or RSQLite. Due to
the large size of the database, SQLite is recommended only for small-scale
testing.}

\item{nFiles}{Maximum number of xml files to parse that are not already in
the database. This should not normally be changed from the default.}

\item{retry}{Logical indicating whether to retry parsing steps that fail.}

\item{nCitations}{Maximum number of rows of the citation file to read. This
should not normally be changed from the default.}

\item{mode}{String indicating whether to create the database using the
baseline files or to update the database using the update files.}

\item{...}{Other arguments passed to \code{\link[DBI:dbConnect]{DBI::dbConnect()}}.}
}
\value{
\code{NULL}, invisibly. Tab-delimited log files will be created in a logs
folder in \code{localDir}.
}
\description{
This function downloads PubMed/MEDLINE XML files, parses them, and adds the
information to the database, then downloads the NIH Open Citation Collection
and adds it to the database. Only the most recent version of each PMID is
retained. Parsing of XML files will use a parallel backend if one is
registered, such as with \code{\link[doParallel:registerDoParallel]{doParallel::registerDoParallel()}}.
}
\examples{
\dontrun{
modifyPubmedDb('.', 'pmdb', mode = 'create')
}

}
\seealso{
\code{\link[=parsePmidStatus]{parsePmidStatus()}}, \code{\link[=getCitation]{getCitation()}}, \code{\link[=getPgParams]{getPgParams()}}
}
