% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DispersalGenerator.R
\name{DispersalGenerator}
\alias{DispersalGenerator}
\title{R6 class representing a dispersal generator.}
\description{
\code{\link[R6:R6Class]{R6}} class functionality for modeling dispersals within a
spatially-explicit population model. The model calculates dispersal rates between
population model cells using a distance-based function: \emph{p*exp(-distance/b)}
for \emph{distance <= r} (otherwise zero), where \emph{p} (proportion), \emph{b}
(breadth or average distance) and \emph{r} (range or maximum distance) are
configurable model attributes. The dispersal rates are adjusted to limit
emigration from each cell to \emph{p}. The model also generates data for
constructing compacted dispersal matrices. It dynamically generates attributes
defined as \emph{outputs} (default: \emph{dispersal_data}) given sampled
\emph{inputs} (default: \emph{dispersal_proportion} and
\emph{dispersal_max_distance}). An optional \code{\link{DispersalFriction}} object
may be utilized to modify (equivalent) distances given a (spatio-temporal) frictional
landscape. When this landscape includes temporal changes, the generated
\emph{dispersal_data} will be a temporal list of changing dispersal rates.
}
\examples{
# U Island example region
coordinates <- data.frame(x = rep(seq(177.01, 177.05, 0.01), 5),
                          y = rep(seq(-18.01, -18.05, -0.01), each = 5))
template_raster <- Region$new(coordinates = coordinates)$region_raster # full extent
template_raster[][-c(7, 9, 12, 14, 17:19)] <- NA # make U Island
region <- Region$new(template_raster = template_raster)
raster::plot(region$region_raster, main = "Example region (indices)",
             xlab = "Longitude (degrees)", ylab = "Latitude (degrees)",
             colNA = "blue")

# Distance-based dispersal generator
dispersal_gen <- DispersalGenerator$new(region = region,
                                        dispersal_max_distance = 3000, # in m
                                        inputs = c("dispersal_p", "dispersal_b"),
                                        decimals = 5)
dispersal_gen$calculate_distance_data() # pre-calculate
dispersal_gen$generate(input_values = list(dispersal_p = 0.5,
                                           dispersal_b = 700))

}
\section{Super classes}{
\code{\link[poems:GenericClass]{poems::GenericClass}} -> \code{\link[poems:GenericModel]{poems::GenericModel}} -> \code{\link[poems:SpatialModel]{poems::SpatialModel}} -> \code{\link[poems:Generator]{poems::Generator}} -> \code{DispersalGenerator}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{attached}}{A list of dynamically attached attributes (name-value pairs).}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{model_attributes}}{A vector of model attribute names.}

\item{\code{region}}{A \code{\link{Region}} (or inherited class) object specifying the study region.}

\item{\code{coordinates}}{Data frame (or matrix) of X-Y population (WGS84) coordinates in longitude (degrees West) and latitude (degrees North) (get and set), or distance-based coordinates dynamically returned by region raster (get only).}

\item{\code{description}}{A brief description of what the generator generates.}

\item{\code{inputs}}{An array of input attribute names for the generator.}

\item{\code{outputs}}{An array of output attribute names for the generator.}

\item{\code{file_templates}}{A nested list of file template attributes.}

\item{\code{function_templates}}{A nested list of function template attributes.}

\item{\code{distribution_templates}}{A list of distribution template attributes.}

\item{\code{uses_correlations}}{A boolean to indicate that a \code{\link{SpatialCorrelation}} (or inherited class) object is used for generating correlated random deviates.}

\item{\code{spatial_correlation}}{A \code{\link{SpatialCorrelation}} (or inherited class) object for generating correlated random deviates.}

\item{\code{temporal_correlation}}{Absolute correlation coefficient between simulation time steps for all grid cells (0-1; default = 1).}

\item{\code{time_steps}}{Number of simulation time steps.}

\item{\code{decimals}}{Number of decimal places applied to generated data outputs (default: NULL = no rounding).}

\item{\code{occupancy_mask}}{Optional binary mask array (matrix), data frame, or raster (stack) for generated (time-series) data outputs.}

\item{\code{template_attached}}{A list of template-nested dynamically attached model attributes that are maintained via shallow or \emph{new} cloning.}

\item{\code{dispersal_friction}}{A \code{\link{DispersalFriction}} (or inherited class) object for dispersal distance multiplier data.}

\item{\code{distance_classes}}{Vector of distance interval boundaries for calculating discrete dispersal rates.}

\item{\code{max_distance_classes}}{The maximum number of distance classes when they are calculated automatically via the maximum distance (default: 1000).}

\item{\code{distance_scale}}{Scale of distance values in meters (default = 1). Usage: set to 1 for values in meters, or to 1000 for values in kilometers.}

\item{\code{distance_data}}{Data frame of distance classes including indices for the construction of compact matrices (columns: target_pop, source_pop, compact_row, distance_class).}

\item{\code{dispersal_function_data}}{Data frame of discrete dispersal function values. Optional first column may provide distance intervals (non-inclusive lower bounds).}

\item{\code{dispersal_proportion}}{Dispersal function: \emph{p*exp(-distance/b)} \emph{p} parameter. Represents the proportion and limit of dispersers between model cells.}

\item{\code{dispersal_breadth}}{Dispersal function: \emph{p*exp(-distance/b)} \emph{b} parameter. Represents the breadth of the dispersal between model cells. Typically estimated via average migration distance.}

\item{\code{dispersal_max_distance}}{Dispersal maximum distance or range (\emph{r}) parameter limits the use of the dispersal function: \emph{p*exp(-distance/b)}. The function is utilized when \emph{distance <= r} otherwise the dispersal rate is set to zero.}

\item{\code{dispersal_index}}{Sampled index for the dispersal function data frame (to look-up dispersal function parameters).}

\item{\code{dispersal_matrix}}{Dispersal matrix calculated via dispersal function.}

\item{\code{dispersal_data}}{Data frame of non-zero dispersal rates including indices for the construction of compact matrices (columns: target_pop, source_pop, emigrant_row, immigrant_row, dispersal_rate).}

\item{\code{attribute_aliases}}{A list of alternative alias names for model attributes (form: \code{alias = "attribute"}) to be used with the set and get attributes methods.}

\item{\code{generative_template}}{A nested \code{\link{DispersalTemplate}} (or inherited class) object for model attributes that are maintained via shallow or \emph{new} cloning.}

\item{\code{generative_requirements}}{A list of attribute names and the template setting (\emph{"file"}, \emph{"function"}, or \emph{"default"}) that is required to generate their values.}

\item{\code{error_messages}}{A vector of error messages encountered when setting model attributes.}

\item{\code{warning_messages}}{A vector of warning messages encountered when setting model attributes.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DispersalGenerator-new}{\code{DispersalGenerator$new()}}
\item \href{#method-DispersalGenerator-generative_requirements_satisfied}{\code{DispersalGenerator$generative_requirements_satisfied()}}
\item \href{#method-DispersalGenerator-set_distance_classes}{\code{DispersalGenerator$set_distance_classes()}}
\item \href{#method-DispersalGenerator-calculate_distance_matrix}{\code{DispersalGenerator$calculate_distance_matrix()}}
\item \href{#method-DispersalGenerator-calculate_distance_data}{\code{DispersalGenerator$calculate_distance_data()}}
\item \href{#method-DispersalGenerator-calculate_dispersals}{\code{DispersalGenerator$calculate_dispersals()}}
\item \href{#method-DispersalGenerator-clone}{\code{DispersalGenerator$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="get_attribute"><a href='../../poems/html/GenericModel.html#method-GenericModel-get_attribute'><code>poems::GenericModel$get_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="get_attribute_aliases"><a href='../../poems/html/GenericModel.html#method-GenericModel-get_attribute_aliases'><code>poems::GenericModel$get_attribute_aliases()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="get_attribute_names"><a href='../../poems/html/GenericModel.html#method-GenericModel-get_attribute_names'><code>poems::GenericModel$get_attribute_names()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="set_attributes"><a href='../../poems/html/GenericModel.html#method-GenericModel-set_attributes'><code>poems::GenericModel$set_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="Generator" data-id="add_distribution_template"><a href='../../poems/html/Generator.html#method-Generator-add_distribution_template'><code>poems::Generator$add_distribution_template()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="Generator" data-id="add_file_template"><a href='../../poems/html/Generator.html#method-Generator-add_file_template'><code>poems::Generator$add_file_template()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="Generator" data-id="add_function_template"><a href='../../poems/html/Generator.html#method-Generator-add_function_template'><code>poems::Generator$add_function_template()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="Generator" data-id="add_generative_requirements"><a href='../../poems/html/Generator.html#method-Generator-add_generative_requirements'><code>poems::Generator$add_generative_requirements()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="Generator" data-id="generate"><a href='../../poems/html/Generator.html#method-Generator-generate'><code>poems::Generator$generate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="Generator" data-id="get_attributes"><a href='../../poems/html/Generator.html#method-Generator-get_attributes'><code>poems::Generator$get_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="Generator" data-id="new_clone"><a href='../../poems/html/Generator.html#method-Generator-new_clone'><code>poems::Generator$new_clone()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="Generator" data-id="read_file"><a href='../../poems/html/Generator.html#method-Generator-read_file'><code>poems::Generator$read_file()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="Generator" data-id="run_function"><a href='../../poems/html/Generator.html#method-Generator-run_function'><code>poems::Generator$run_function()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="Generator" data-id="sample_distribution"><a href='../../poems/html/Generator.html#method-Generator-sample_distribution'><code>poems::Generator$sample_distribution()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DispersalGenerator-new"></a>}}
\if{latex}{\out{\hypertarget{method-DispersalGenerator-new}{}}}
\subsection{Method \code{new()}}{
Initialization method sets the generative template and requirements, optionally the dispersal friction object, as well as any attributes passed via a \emph{params} list or individually.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DispersalGenerator$new(
  generative_template = NULL,
  generative_requirements = NULL,
  dispersal_friction = NULL,
  attribute_aliases = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{generative_template}}{Optional nested object for generative attributes that need to be maintained when a new clone object is generated for a sample simulation (usually a ).}

\item{\code{generative_requirements}}{Optional list of attribute names and the template setting (\emph{"file"} or \emph{"function"}) that is required to generate their values (otherwise default functionality is used).}

\item{\code{dispersal_friction}}{Optional \code{\link{DispersalFriction}} (or inherited class) object for dispersal distance multiplier data.}

\item{\code{attribute_aliases}}{Optional list of extra alias names for model attributes (form: \code{alias = "attribute"}) to be used with the set and get attributes methods.}

\item{\code{...}}{Parameters passed via a \emph{params} list or individually.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DispersalGenerator-generative_requirements_satisfied"></a>}}
\if{latex}{\out{\hypertarget{method-DispersalGenerator-generative_requirements_satisfied}{}}}
\subsection{Method \code{generative_requirements_satisfied()}}{
Returns a boolean to indicate that all the default, file and/or function template settings that are required for attribute generation are present.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DispersalGenerator$generative_requirements_satisfied()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Boolean to indicate that the required settings for attribute generation are present.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DispersalGenerator-set_distance_classes"></a>}}
\if{latex}{\out{\hypertarget{method-DispersalGenerator-set_distance_classes}{}}}
\subsection{Method \code{set_distance_classes()}}{
Sets the distance classes to a sequence of values from minimum to maximum in steps of interval size.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DispersalGenerator$set_distance_classes(
  minimum = 1,
  maximum = 10,
  interval = 1
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{minimum}}{Minimum or first distance class sequence value (default = 1).}

\item{\code{maximum}}{Maximum or last distance class value (default = 10).}

\item{\code{interval}}{Interval or distance class sequence step size  (default = 1).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DispersalGenerator-calculate_distance_matrix"></a>}}
\if{latex}{\out{\hypertarget{method-DispersalGenerator-calculate_distance_matrix}{}}}
\subsection{Method \code{calculate_distance_matrix()}}{
Returns a matrix with the calculated distance (in meters by default) between each pair of region cells.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DispersalGenerator$calculate_distance_matrix(use_longlat = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_longlat}}{Optional boolean indicating use of (WGS84) coordinates in longitude (degrees West) and latitude (degrees North).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Matrix with distances between region cells.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DispersalGenerator-calculate_distance_data"></a>}}
\if{latex}{\out{\hypertarget{method-DispersalGenerator-calculate_distance_data}{}}}
\subsection{Method \code{calculate_distance_data()}}{
Calculates the distance class for within-range populations using the set/provided distance classes. Also calculates indices for constructing compact matrices.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DispersalGenerator$calculate_distance_data(distance_matrix = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{distance_matrix}}{Optional pre-calculated matrix with distances between population cells (population rows by population columns).}

\item{\code{...}}{Parameters passed via a \emph{params} list or individually.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DispersalGenerator-calculate_dispersals"></a>}}
\if{latex}{\out{\hypertarget{method-DispersalGenerator-calculate_dispersals}{}}}
\subsection{Method \code{calculate_dispersals()}}{
Calculates, using the conditional dispersal limiting function for a simulation sample, a dispersal matrix, or a list of data frames of non-zero dispersal rates and indices for constructing a compact dispersal matrix (default), and optional changing rates over time (via \code{\link{DispersalFriction}} object).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DispersalGenerator$calculate_dispersals(type = "data")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{type}}{Optional type selector (\emph{"data"} or \emph{"matrix"}) to determine whether to calculate a dispersal matrix or data frame (default).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns character string message when calculation prerequisites are not met (for simulation logging).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DispersalGenerator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DispersalGenerator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DispersalGenerator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
