% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Region.R
\name{Region}
\alias{Region}
\title{R6 class representing a study region.}
\description{
\code{\link[R6:R6Class]{R6}} class representing a study region of spatial grid cells
defined via a list of longitude/latitude cell coordinates (WGS84), or a
\emph{RasterLayer} object (see \code{\link[raster:raster-package]{raster}}).
}
\examples{
# U Island example region
coordinates <- data.frame(x = rep(seq(177.01, 177.05, 0.01), 5),
                          y = rep(seq(-18.01, -18.05, -0.01), each = 5))
template_raster <- Region$new(coordinates = coordinates)$region_raster # full extent
template_raster[][-c(7, 9, 12, 14, 17:19)] <- NA # make U Island
region <- Region$new(template_raster = template_raster)
raster::plot(region$region_raster, main = "Example region (cell indices)",
             xlab = "Longitude (degrees)", ylab = "Latitude (degrees)",
             colNA = "blue")
region$region_cells
region$coordinates
# Generate value layers
value_brick <- region$raster_from_values(array(8:28, c(7, 3)))
raster::plot(value_brick, main = "Example value layers",
             xlab = "Longitude (degrees)", ylab = "Latitude (degrees)",
             colNA = "blue")
value_brick[region$region_indices]

}
\section{Super class}{
\code{\link[poems:GenericClass]{poems::GenericClass}} -> \code{Region}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{attached}}{A list of dynamically attached attributes (name-value pairs).}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{coordinates}}{Data frame (or matrix) of X-Y population (WGS84) coordinates in longitude (degrees West) and latitude (degrees North) (get and set), or distance-based coordinates dynamically returned by region raster (get only).}

\item{\code{region_raster}}{A \emph{RasterLayer} object (see \code{\link[raster:raster-package]{raster}}) defining the region with finite values (NAs elsewhere).}

\item{\code{use_raster}}{Boolean to indicate that a raster is to be used to define the region (default TRUE).}

\item{\code{strict_consistency}}{Boolean to indicate that, as well as resolution, extent and CRS, consistency checks also ensure that a raster's finite/occupiable cells are the same or a subset of those defined by the region (default TRUE).}

\item{\code{region_cells}}{Dynamically calculated number of region coordinates or raster cells with finite/non-NA values.}

\item{\code{region_indices}}{Dynamically calculated region indices for raster cells with finite/non-NA values (all if not a raster).}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Region-new}{\code{Region$new()}}
\item \href{#method-Region-raster_is_consistent}{\code{Region$raster_is_consistent()}}
\item \href{#method-Region-raster_from_values}{\code{Region$raster_from_values()}}
\item \href{#method-Region-clone}{\code{Region$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericClass" data-id="new_clone"><a href='../../poems/html/GenericClass.html#method-GenericClass-new_clone'><code>poems::GenericClass$new_clone()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Region-new"></a>}}
\if{latex}{\out{\hypertarget{method-Region-new}{}}}
\subsection{Method \code{new()}}{
Initialization method sets coordinates or raster for region.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Region$new(
  coordinates = NULL,
  template_raster = NULL,
  region_raster = NULL,
  use_raster = TRUE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{coordinates}}{Data frame (or matrix) of X-Y coordinates (WGS84) in longitude (degrees West) and latitude (degrees North).}

\item{\code{template_raster}}{A \emph{RasterLayer} object (see \code{\link[raster:raster-package]{raster}}) defining the region with example finite values (NAs elsewhere)}

\item{\code{region_raster}}{A \emph{RasterLayer} object (see \code{\link[raster:raster-package]{raster}}) defining the region with finite cell indices (NAs elsewhere).}

\item{\code{use_raster}}{Boolean to indicate that a raster is to be used to define the region (default TRUE).}

\item{\code{...}}{Additional parameters passed individually.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Region-raster_is_consistent"></a>}}
\if{latex}{\out{\hypertarget{method-Region-raster_is_consistent}{}}}
\subsection{Method \code{raster_is_consistent()}}{
Returns a boolean to indicate if a raster is consistent with the region raster (matching extent, resolution, and finite/NA cells).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Region$raster_is_consistent(check_raster)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{check_raster}}{A \emph{RasterLayer}, \emph{RasterStack} or \emph{RasterBrick} object (see \code{\link[raster:raster-package]{raster}}) to check for consistency with the region raster.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Boolean to indicate if the raster is consistent with the region raster.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Region-raster_from_values"></a>}}
\if{latex}{\out{\hypertarget{method-Region-raster_from_values}{}}}
\subsection{Method \code{raster_from_values()}}{
Converts an array (or matrix) of values into a raster (or stack) consistent with the region raster (matching extent, resolution, and finite/NA cells).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Region$raster_from_values(values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{values}}{An array (or matrix) of values to be placed in the raster (or stack) having dimensions consistent with the region cell number.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \emph{RasterLayer} (or \emph{RasterStack/Brick}) object consistent with the region raster.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Region-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Region-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Region$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
