% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poismf.R
\name{get.all.predictions}
\alias{get.all.predictions}
\title{Predict whole input matrix}
\usage{
get.all.predictions(model)
}
\arguments{
\item{model}{A Poisson factorization model as output by function `poismf`.}
}
\value{
A matrix [dimA x dimB] with the full predictions for all rows and columns.
If the `X` data passed to `poismf` was a `data.frame`, the resulting output will have
row and column names added to it. Be aware that, if `X` was a `data.frame` with integers
as IDs, selecting columns or rows of the named matrix will output ordinal positions
- e.g. `out[2,]` (second row) vs. `out["2",]` (row for ID=2 in `X`).
The mappings, if produced, can be obtained through function \link{get.model.mappings}.
}
\description{
Outputs the predictions for the whole input matrix to which the model was fit.
Note that this will be a dense matrix, and in typical recommender systems scenarios will
likely not fit in memory.
}
