% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poker.R
\name{dotStraightFlushRanker}
\alias{dotStraightFlushRanker}
\title{dotStraightFlushRanker}
\usage{
dotStraightFlushRanker(yTempRow)
}
\arguments{
\item{yTempRow}{: \tabular{ll}{a sorted 7 card hand of numbers as
vector[7] \tab \cr \tab
col1: number of card 1 in \{1, 2, ... , 52\} \cr \tab
col2: number of card 2 \cr \tab
. \cr \tab
. \cr \tab
. \cr \tab
col7: number of card 7}}
}
\value{
straightFlushRank : the top card in the straight flush as
											integer
}
\description{
Determine the rank of the highest card in a straight flush. This function assumes cards are sorted in ascending order.
}
\examples{
dotStraightFlushRanker(c(1,2,3,4,5,15,19))
dotStraightFlushRanker(c(9,10,11,12,13,35,42))
dotStraightFlushRanker(c(9,10,11,12,13,14,35))
dotStraightFlushRanker(c(1,2,3,4,13,20,35))
dotStraightFlushRanker(c(9,26,14,15,16,17,35))
}
