% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_disproportion.R
\name{compute_disproportion}
\alias{compute_disproportion}
\title{Calcula Desproporción del Sistema de Partidos 
 (\emph{Computes Party System Disproportion})}
\usage{
compute_disproportion(data, formula = "gallagher")
}
\arguments{
\item{data}{la base de datos para hacer el cálculo obtenida con \code{\link{get_election_data}} 
(\emph{tiblle downloaded with \code{\link{get_election_data}} needed to compute disproportion}).}

\item{formula}{variante de cálculo elegido ('gallagher', 'cox_shugart', 'lijphart' o 'rae'). Por defecto es la formula de Gallagher}
}
\value{
Devuelve un tibble con \code{class "tbl_df","tbl", "data.frame"} con el cómputo
 (\emph{Returns a tibble with \code{class "tbl_df", "tbl", "data.frame"} with the computation}).
}
\description{
Función que calcula el índice de desprorpoción del sistema de partidos midiendo la distancia relativa entre proporción de votos
y de bancas obtendios por los partidos políticos (Gallagher por defecto)
 (\emph{Function that computes the party system disproportion index})
}
\details{
Una discusión sobre distintas formulas para el cálculo puede encontrarse en 
\emph{\href{https://journals.sagepub.com/doi/10.1177/001041407901200101}{"Taagepera and Grofman (2009)"}} 
(A discussion of different ways to compute it can be found at
\emph{\href{https://journals.sagepub.com/doi/10.1177/001041407901200101}{"Taagepera and Grofman (2009)"}})

\strong{REQUISITO:}

El formato de \code{data} debe ser \code{long} para calcular \code{\link{compute_disproportion}}. 
 Si \code{data} es \emph{wide} se puede transformar con \code{\link{make_long}}  
 (\emph{\code{long} format of \code{data} is required for \code{\link{compute_disproportion}}. 
 If \code{data} is in \emph{wide} format you can transform it with \code{\link{make_long}}})

\strong{NOTA:}

para calcular el grado de desprorpoción el parámetro \code{level} de \code{\link{get_election_data}} debe ser el que descarga por defecto: "provincia"  
 (\emph{To compute the degree of disproportion, the parameter \code{level} of \code{\link{get_election_data}} must be "provincia" (\emph{default})}).
}
\examples{

tucuman_dip_gral_2017

tucuman_dip_gral_2017 \%>\% 
  compute_disproportion()

}
\seealso{
\code{\link{compute_competitiveness}, \link{compute_seats}, \link{compute_nep}}
}
