% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__datetime.R
\name{ExprDT_combine}
\alias{ExprDT_combine}
\alias{(Expr)$dt$combine}
\title{Combine Data and Time}
\format{
function
}
\arguments{
\item{tm}{Expr or numeric or PTime, the number of epoch since or before(if negative) the Date
or tm is an Expr e.g. a column of DataType 'Time' or something into an Expr.}

\item{tu}{time unit of epochs, default is "us", if tm is a PTime, then tz passed via PTime.}
}
\value{
Date/Datetime expr
}
\description{
Create a naive Datetime from an existing Date/Datetime expression and a Time.
Each date/datetime in the first half of the interval
is mapped to the start of its bucket.
Each date/datetime in the second half of the interval
is mapped to the end of its bucket.
}
\details{
The \code{tu} allows the following time time units
the following string language:
\itemize{
\item 1ns # 1 nanosecond
\item 1us # 1 microsecond
\item 1ms # 1 millisecond
}
}
\examples{
# Using pl$PTime
pl$lit(as.Date("2021-01-01"))$dt$combine(pl$PTime("02:34:12"))$lit_to_s()
pl$lit(as.Date("2021-01-01"))$dt$combine(pl$PTime(3600 * 1.5, tu = "s"))$lit_to_s()
pl$lit(as.Date("2021-01-01"))$dt$combine(pl$PTime(3600 * 1.5E6 + 123, tu = "us"))$lit_to_s()

# pass double and set tu manually
pl$lit(as.Date("2021-01-01"))$dt$combine(3600 * 1.5E6 + 123, tu = "us")$lit_to_s()

# if needed to convert back to R it is more intuitive to set a specific time zone
expr = pl$lit(as.Date("2021-01-01"))$dt$combine(3600 * 1.5E6 + 123, tu = "us")
expr$cast(pl$Datetime(tu = "us", tz = "GMT"))$to_r()
}
\keyword{ExprDT}
