% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__list.R
\name{arr_to_struct}
\alias{arr_to_struct}
\alias{arr.to_struct}
\title{List to Struct}
\format{
function
}
\arguments{
\item{n_field_strategy}{Strategy to determine the number of fields of the struct.
default = 'first_non_null' else 'max_width'}

\item{name_generator}{an R function that takes a scalar column number
and outputs a string value. The default NULL is equivalent to the R function
\verb{\\(idx) paste0("field_",idx)}}

\item{upper_bound}{upper_bound numeric
A polars \code{LazyFrame} needs to know the schema at all time.
The caller therefore must provide an \code{upper_bound} of
struct fields that will be set.
If this is incorrectly downstream operation may fail.
For instance an \verb{all().sum()} expression will look in
the current schema to determine which columns to select.
It is advised to set this value in a lazy query.}
}
\value{
Expr
}
\description{
List to Struct
}
\examples{
df = pl$DataFrame(list(a = list(1:3, 1:2)))
df2 = df$select(pl$col("a")$arr$to_struct(
  name_generator = \(idx) paste0("hello_you_", idx)
))
df2$unnest()

df2$to_list()
}
\keyword{ExprArr}
