% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iplotC.r
\name{iplotC}
\alias{iplotC}
\title{Interaction plot}
\usage{
iplotC(function1 = NULL, function2 = NULL, data, function3 = NULL, ...)
}
\arguments{
\item{function1}{A function in the form ~depvar}

\item{function2}{A function. Here indepvar is typed before controlvar: ~indepvar + controlvar}

\item{data}{Design dataset (e.g. nesD, gssD, statesD, or worldD)}

\item{function3}{A function. Here indepvar is typed after controlvar: ~controlvar + indepvar}

\item{...}{Further arguments to be passed to \code{\link[plotrix]{brkdn.plot}} function (plotrix package)}
}
\value{
No value returned
}
\description{
Interaction plot uses \code{\link[plotrix]{brkdn.plot}} in plotrix package and \code{\link[survey]{svyby}} function from survey package. Warnings suppressed so the function creates plot without generating intermediate results used to create plot.
}
\examples{
   library(poliscidata)
   
   iplotC(function1 = ~ ft_dem, function2 = ~ gender + married, 
          data = nesD, function3 = ft_dem ~ married + gender)
   
   iplotC(~ft_dem, ~gender+married, nesD, ft_dem~married+gender,
          xlab="Gender", ylab="Democratic Party Rating", 
          main="Democratic Party Rating by Gender and Marital Status")
}

