% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pollstr.R
\name{pollster_iter}
\alias{pollster_iter}
\alias{pollster_charts_iter}
\alias{pollster_questions_iter}
\alias{pollster_polls_iter}
\title{Fetch multiple pages}
\usage{
pollster_iter(.f, ..., cursor = NULL, .max_pages = 1, .debug = FALSE)

pollster_charts_iter(cursor = NULL, tags = NULL, election_date = NULL,
  .max_pages = 1, ...)

pollster_questions_iter(cursor = NULL, tags = NULL, election_date = NULL,
  .max_pages = 1, ...)

pollster_polls_iter(cursor = NULL, tags = NULL, question = NULL,
  sort = c("created_at", "updated_at"), .max_pages = 1, ...)
}
\arguments{
\item{.f}{A pollster function for an endpoint that uses a \code{cursor}.}

\item{...}{Arguments for \code{.f}}

\item{cursor}{Special string used to handle pagination.}

\item{.max_pages}{The maximum number of pages to fetch.}

\item{.debug}{If \code{TRUE} prints the url and cursor number while fetching the pages.}

\item{tags}{Character vector of tag names.}

\item{election_date}{A date object or a string in "YYYY-MM-DD" format for the election date.}

\item{question}{Question slug.}

\item{sort}{Sort order of polls.}
}
\value{
A list of the results.
}
\description{
For Pollster methods that return results in pages (those with a \code{cursor} argument), iterate over multiple pages.
}
\section{Functions}{
\itemize{
\item \code{pollster_charts_iter}: Return a list of charts. See href{https://app.swaggerhub.com/swagger-ui/#!/default/get_charts}{API Docs}. This is the paginated version of \code{pollster_charts}.

\item \code{pollster_questions_iter}: Get a question. This is the paginated form of \code{\link{pollster_questions}}.

\item \code{pollster_polls_iter}: Get polls. This function is the paginated version of \code{\link{pollster_polls}}.
}}

