% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sAttributes_method.R
\docType{methods}
\name{sAttributes,character-method}
\alias{sAttributes}
\alias{sAttributes,character-method}
\alias{sAttributes,partition-method}
\title{Get s-attributes.}
\usage{
\S4method{sAttributes}{character}(.Object, sAttribute = NULL, unique = TRUE,
  regex = NULL)

\S4method{sAttributes}{partition}(.Object, sAttribute = NULL)
}
\arguments{
\item{.Object}{either a \code{partition} or a character vector specifying a CWB corpus}

\item{sAttribute}{name of a specific s-attribute}

\item{unique}{logical, whether to return unique values only}

\item{regex}{filter return value by applying a regex}
}
\value{
a character vector
}
\description{
Structural annotations (s-attributes) of a corpus provide metainformation for
ranges of text. Importing XML into the Corpus Workbench (CWB) turns elements and element
attributes into s-attributes. There are two uses of the sAttributes-method: If the 
\code{sAttribute} parameter is NULL (default), the return value is a character vector
with all s-attributes. If sAttribute is the name of a specific s-attribute (i.e. a 
length 1 character vector), the respective s-attributes available in the corpus are 
returned.
}
\examples{
\dontrun{
  use("polmineR.sampleCorpus")
  
  sAttributes("PLPRBTTXT")
  sAttributes("PLPRBTTXT", "text_date") # dates of plenary meetings
  
  P <- partition("PLPRBTTXT", text_date = "2009-11-10")
  sAttributes(P)
  sAttributes(P, "text_name") # get names of speakers
}
}

