% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_method.R
\docType{methods}
\name{count}
\alias{count}
\alias{count,character-method}
\alias{count,partition-method}
\alias{count,partitionBundle-method}
\alias{count,vector-method}
\alias{count-method}
\title{Get counts.}
\usage{
count(.Object, ...)

\S4method{count}{partition}(.Object, query = NULL, cqp = is.cqp,
  id2str = TRUE, pAttribute = getOption("polmineR.pAttribute"),
  mc = getOption("polmineR.cores"), verbose = TRUE, progress = FALSE)

\S4method{count}{partitionBundle}(.Object, query, pAttribute = NULL,
  freq = FALSE, total = TRUE, mc = FALSE, progress = TRUE,
  verbose = FALSE)

\S4method{count}{character}(.Object, query = NULL, cqp = is.cqp,
  pAttribute = getOption("polmineR.pAttribute"), sort = FALSE,
  id2str = TRUE, verbose = TRUE)

\S4method{count}{vector}(.Object, corpus, pAttribute)
}
\arguments{
\item{.Object}{a \code{"partition"} or \code{"partitionBundle"} object, or a
character vector (length 1) providing the name of a corpus}

\item{...}{further parameters}

\item{query}{a character vector (one or multiple terms to be looked up), CQP
syntax can be used.}

\item{cqp}{either logical (TRUE if query is a CQP query), or a
function to check whether query is a CQP query or not (defaults to is.query
auxiliary function)}

\item{id2str}{logical, whether to add rownames (only if query is NULL)}

\item{pAttribute}{the p-attribute(s) to use}

\item{mc}{logical, whether to use multicore (defaults to FALSE)}

\item{verbose}{logical, whether to be verbose}

\item{progress}{logical, whether to show progress}

\item{freq}{logical, if FALSE, counts will be reported, if TRUE, frequencies}

\item{total}{defaults to FALSE, if TRUE, the added value of counts (column:
TOTAL) will be amended to the data.table that is returned}

\item{sort}{logical, whether to sort stat}

\item{corpus}{name of CWB corpus}
}
\value{
a \code{"data.table"}
}
\description{
Count all tokens, or number of occurrences of a query (CQP syntax may be used).
}
\details{
If .Object is a partitonBundle, the data.table returned will have the queries
in the columns, and as many rows as there are in the partitionBundle.
}
\examples{
\dontrun{
  use("polmineR.sampleCorpus")
  debates <- partition("PLPRBTTXT", list(text_id=".*"), regex=TRUE)
  x <- count(debates, "Arbeit") # get frequencies for one token
  x <- count(debates, c("Arbeit", "Freizeit", "Zukunft")) # get frequencies for multiple tokens
  x <- count("PLPRBTTXT", query = c("Migration", "Integration"), "word")

  debates <- partitionBundle(
    "PLPRBTTXT", sAttribute = "text_date", values = NULL,
    regex = TRUE, mc = FALSE, verbose = FALSE
  )
}
}
\seealso{
For a metadata-based breakdown of counts
(i.e. tabulation by s-attributes), see \code{"dispersion"}.

count
}

