% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4classes.R, R/p_attributes.R, R/partition.R,
%   R/enrich.R, R/regions.R, R/split.R
\docType{class}
\name{partition_class}
\alias{partition_class}
\alias{partition-class}
\alias{show,partition-method}
\alias{[,partition,ANY,ANY,ANY-method}
\alias{[,partition-method}
\alias{as.partition_bundle}
\alias{as.partition_bundle,partition-method}
\alias{export}
\alias{export,partition-method}
\alias{split}
\alias{remote_partition-class}
\alias{plpr_partition-class}
\alias{press_partition-class}
\alias{p_attributes,partition-method}
\alias{p_attributes,subcorpus-method}
\alias{is.partition}
\alias{enrich,partition-method}
\alias{as.regions,partition-method}
\alias{split,partition-method}
\title{Partition class and methods.}
\usage{
\S4method{p_attributes}{partition}(.Object, p_attribute = NULL, decode = TRUE)

\S4method{p_attributes}{subcorpus}(.Object, p_attribute = NULL, decode = TRUE)

is.partition(x)

\S4method{enrich}{partition}(
  .Object,
  p_attribute = NULL,
  decode = TRUE,
  verbose = TRUE,
  mc = FALSE,
  ...
)

\S4method{as.regions}{partition}(x)

\S4method{split}{partition}(x, gap, ...)
}
\arguments{
\item{.Object}{A \code{partition} object.}

\item{p_attribute}{a p-attribute (for enriching) / performing count.}

\item{decode}{\code{logical} value, whether to decode token ids into strings when performing count}

\item{x}{A \code{partition} object.}

\item{verbose}{\code{logical} value, whether to output messages}

\item{mc}{\code{logical} or, if numeric, providing the number of cores}

\item{...}{further parameters passed into \code{count} when calling \code{enrich}, and ...}

\item{gap}{An integer value specifying the minimum gap between regions for
performing the split.}
}
\description{
The \code{partition} class is used to manage subcorpora. It is an S4 class, and
a set of methods is defined for the class. The class inherits
from the classes \code{count} and \code{textstat}.
}
\details{
As \code{partition} objects inherit from \code{count} and
  \code{textstat} class, methods available are \code{view} to inspect the
  table in the \code{stat} slot, \code{name} and \code{name<-} to
  retrieve/set the name of an object, and more.

The \code{is.partition} function returns a \code{logical} value
  whether \code{x} is a \code{partition}, or not.

The \code{enrich}-method will add a count of tokens defined by argument
\code{p_attribute} to slot \code{stat} of the \code{partition} object.

The \code{split}-method will split a partition object into a
\code{partition_bundle} if gap between strucs exceeds a minimum number of
tokens specified by \code{gap}. Relevant to split up a plenary protocol# into
speeches. Note: To speed things up, the returned partitions will not include
frequency lists. The lists can be prepared by applying \code{enrich} on the
\code{partition_bundle} object that is returned.
}
\section{Slots}{

\describe{
\item{\code{name}}{A name to identify the object (\code{character} vector with length 1); useful when multiple
\code{partition} objects are combined to a \code{partition_bundle}.}

\item{\code{corpus}}{The CWB indexed corpus the partition is derived from (\code{character} vector with length 1).}

\item{\code{encoding}}{Encoding of the corpus (\code{character} vector with length 1).}

\item{\code{s_attributes}}{A named \code{list} with the s-attributes specifying the partition.}

\item{\code{explanation}}{Object of class \code{character}, an explanation of the partition.}

\item{\code{cpos}}{A \code{matrix} with left and right corpus positions defining regions (two columns).}

\item{\code{annotations}}{Object of class \code{list}.}

\item{\code{size}}{Total size of the partition (\code{integer} vector, length 1).}

\item{\code{stat}}{An (optional) \code{data.table} with counts. If present, speeds up computation of cooccurrences,
as count is already present.}

\item{\code{metadata}}{Object of class \code{data.frame}, metadata information.}

\item{\code{strucs}}{Object of class \code{intger}, the strucs defining the partition.}

\item{\code{p_attribute}}{Object of class \code{character} indicating the p_attribute of the
count in slot \code{stat}.}

\item{\code{xml}}{Object of class \code{character}, whether the xml is flat or nested.}

\item{\code{s_attribute_strucs}}{Object of class \code{character} the base node}

\item{\code{key}}{Experimental, an s-attribute that is used as a key.}

\item{\code{call}}{Object of class \code{character} the call that generated the partition}
}}

\examples{
p <- partition("GERMAPARLMINI", date = "2009-11-11", speaker = "Norbert Lammert")
name(p) <- "Norbert Lammert"
pb <- split(p, gap = 500L)
summary(pb)
}
\seealso{
The \code{partition}-class inherits from the \code{\link{textstat-class}}, see
respective documentation to learn more.
}
\author{
Andreas Blaette
}
