% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{screen_for_NA_values}
\alias{screen_for_NA_values}
\title{Screen marker data for NA values}
\usage{
screen_for_NA_values(
  dosage_matrix,
  margin = 1,
  cutoff = NULL,
  parentnames = c("P1", "P2"),
  plot_breakdown = FALSE,
  log = NULL,
  print.removed = TRUE
)
}
\arguments{
\item{dosage_matrix}{An integer matrix with markers in rows and individuals in columns.}

\item{margin}{An integer at which margin the missing value frequency will be calculated. A value of 1 means rows (markers), 2 means columns (individuals)}

\item{cutoff}{Missing value frequency cut off. At this frequency, rows or columns are removed from the dataset. If NULL user input will be asked after plotting the missing value frequency histogram.}

\item{parentnames}{A character vector of length 2, specifying the parent names.}

\item{plot_breakdown}{Logical. Should the percentage of markers removed as breakdown per markertype be plotted? Can only be used if margin = 1.}

\item{log}{Character string specifying the log filename to which standard output should be written. If NULL log is send to stdout.}

\item{print.removed}{Logical. Should removed instances be printed?}
}
\value{
A matrix similar to dosage_matrix, with rows or columns removed that had a higher missing value frequency than specified.
}
\description{
\code{screen_for_NA_values} identifies and can remove rows or columns of a marker dataset based on the relative frequency of missing values.
}
\examples{
data("segregating_data","screened_data")
screened_markers<-screen_for_NA_values(dosage_matrix=segregating_data, margin=1, cutoff=0.1)
screened_indiv<-screen_for_NA_values(dosage_matrix=screened_data, margin=2, cutoff=0.1)
}
