require(pomp)

simulate(
         pomp(
              data=rbind(obs=rep(0,1000)),
              times=seq(0.1,by=0.1,length=1000),
              t0=0,
              rprocess=euler.sim(
                step.fun=function(x,t,params,delta.t,...){
                  with(
                       as.list(c(x,params)),
                       rnorm(
                             n=1,
                             mean=n+r*n*(1-n/K)*delta.t,
                             sd=sigma*n*sqrt(delta.t)
                             )
                       )
                },
                delta.t=0.01
                ),
              dprocess=onestep.dens(
                dens.fun=function(x1,x2,t1,t2,params,log,...){
                  delta.t <- t2-t1
                  with(
                       as.list(c(x1,params)),
                       dnorm(
                             x=x2['n'],
                             mean=n+r*n*(1-n/K)*delta.t,
                             sd=sigma*n*sqrt(delta.t),
                             log=log
                             )
                       )
                }
                ),
              measurement.model=obs~lnorm(meanlog=log(n),sdlog=log(1+tau)),
              skeleton.type="vectorfield",
              skeleton=function(x,t,params,...){
                with(
                     as.list(c(x,params)),
                     r*n*(1-n/K)
                     )
              }
              ),
         params=c(
           n.0=10000,
           K=10000,
           r=0.9,
           sigma=0.4,
           tau=0.1
           ),
         nsim=1,
         seed=73658676L
         ) -> verhulst

save(verhulst,file="verhulst.rda")
