% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_data_frame.R, R/objfun.R, R/melt.R
\docType{methods}
\name{as.data.frame}
\alias{as.data.frame}
\alias{coerce-pomp-data.frame}
\alias{coerce,pomp,data.frame-method}
\alias{as.data.frame.pomp}
\alias{as,pfilterd_pomp-method}
\alias{coerce,pfilterd_pomp,data.frame-method}
\alias{as.data.frame.pfilterd_pomp}
\alias{as,probed_pomp-method}
\alias{coerce,probed_pomp,data.frame-method}
\alias{as.data.frame.probed_pomp}
\alias{as,kalmand_pomp-method}
\alias{coerce,kalmand_pomp,data.frame-method}
\alias{as.data.frame.kalmand_pomp}
\alias{as,bsmcd_pomp-method}
\alias{coerce,bsmcd_pomp,data.frame-method}
\alias{as.data.frame.bsmcd_pomp}
\alias{as,listie-method}
\alias{coerce,listie,data.frame-method}
\alias{as.data.frame.pompList}
\alias{as.data.frame.pfilterList}
\alias{as.data.frame.abcList}
\alias{as.data.frame.mif2List}
\alias{as.data.frame.pmcmcList}
\alias{coerce-objfun-data.frame}
\alias{coerce,objfun,data.frame-method}
\alias{melt,pomp-method}
\title{Coerce to data frame}
\usage{
\method{as.data.frame}{pomp}(x, ...)

\method{as.data.frame}{pfilterd_pomp}(x, ...)

\method{as.data.frame}{probed_pomp}(x, ...)

\method{as.data.frame}{kalmand_pomp}(x, ...)

\method{as.data.frame}{bsmcd_pomp}(x, ...)

\method{as.data.frame}{pompList}(x, ...)

\method{as.data.frame}{pfilterList}(x, ...)

\method{as.data.frame}{abcList}(x, ...)

\method{as.data.frame}{mif2List}(x, ...)

\method{as.data.frame}{pmcmcList}(x, ...)

\S4method{melt}{pomp}(data, ..., na.rm = FALSE, value.name = "value")
}
\arguments{
\item{x}{any \R object.}

\item{...}{additional arguments to be passed to or from methods.}

\item{data}{Data set to melt}

\item{na.rm}{Should NA values be removed from the data set? This will
convert explicit missings to implicit missings.}

\item{value.name}{name of variable used to store values}
}
\description{
All \pkg{pomp} model objects can be recast as data frames.
The contents of the resulting data frame depend on the nature of the object.
}
\details{
When \code{object} is a simple \sQuote{pomp} object,
\code{as(object,"data.frame")} or \code{as.data.frame(object)} results in a
data frame with the times, observables, states (if known), and
interpolated covariates (if any).

When \code{object} is a \sQuote{pfilterd_pomp} object,
coercion to a data frame results in a data frame with the same content as for a simple \sQuote{pomp},
but with conditional log likelihood and effective sample size estimates included.

When \code{object} is a \sQuote{probed_pomp} object,
coercion to a data frame results in a data frame with the values of the probes computed on the data and on simulations.

When \code{object} is a \sQuote{kalmand_pomp} object,
coercion to a data frame results in a data frame with prediction means, filter means and forecasts, in addition to the data.

When \code{object} is a \sQuote{bsmcd_pomp} object,
coercion to a data frame results in a data frame with samples from the prior and posterior distribution.
The \code{.id} variable distinguishes them.

A \sQuote{pomp} object can be melted into a data frame.
}
