% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pomp.R
\name{pomp}
\alias{pomp}
\title{Constructor of the basic pomp object}
\usage{
pomp(data, times, t0, ..., rinit, rprocess, dprocess, rmeasure, dmeasure,
  skeleton, rprior, dprior, partrans, covar, params, accumvars, obsnames,
  statenames, paramnames, covarnames, PACKAGE, globals,
  cdir = getOption("pomp_cdir", NULL), cfile, shlib.args,
  compile = TRUE, verbose = getOption("verbose", FALSE))
}
\arguments{
\item{data}{either a data frame holding the time series data,
or an object of class \sQuote{pomp},
i.e., the output of another \pkg{pomp} calculation.}

\item{times}{the times at which observations are made.
\code{times} must indicate the column of observation times by name or index.
The time vector must be numeric and non-decreasing.
Internally, \code{data} will be internally coerced to an array with storage-mode \code{double}.}

\item{t0}{The zero-time, i.e., the time of the initial state.
This must be no later than the time of the first observation, i.e., \code{t0 <= times[1]}.}

\item{\dots}{additional arguments supply new or modify existing model characteristics or components.
See \code{\link{pomp}} for a full list of recognized arguments.

When named arguments not recognized by \code{\link{pomp}} are provided, these are made available to all basic components via the so-called \dfn{userdata} facility.
This allows the user to pass information to the basic components outside of the usual routes of covariates (\code{covar}) and model parameters (\code{params}).
See \link[=userdata]{?userdata} for information on how to use this facility.}

\item{rinit}{simulator of the initial-state distribution.
This can be furnished either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{rinit=NULL} sets the initial-state simulator to its default.
For more information, see \link[=rinit_spec]{?rinit_spec}.}

\item{rprocess}{simulator of the latent state process, specified using one of the \link[=rprocess_spec]{rprocess plugins}.
Setting \code{rprocess=NULL} removes the latent-state simulator.
For more information, \link[=rprocess_spec]{see ?rprocess_spec for the documentation on these plugins}.}

\item{dprocess}{optional;
specification of the probability density evaluation function of the unobserved state process.
Setting \code{dprocess=NULL} removes the latent-state density evaluator.
For more information, see \link[=dprocess_spec]{?dprocess_spec}.}

\item{rmeasure}{simulator of the measurement model, specified either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{rmeasure=NULL} removes the measurement model simulator.
For more information, see \link[=rmeasure_spec]{?rmeasure_spec}.}

\item{dmeasure}{evaluator of the measurement model density, specified either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{dmeasure=NULL} removes the measurement density evaluator.
For more information, see \link[=dmeasure_spec]{?dmeasure_spec}.}

\item{skeleton}{optional; the deterministic skeleton of the unobserved state process.
Depending on whether the model operates in continuous or discrete time, this is either a vectorfield or a map.
Accordingly, this is supplied using either the \code{\link[=skeleton_spec]{vectorfield}} or \code{\link[=skeleton_spec]{map}} fnctions.
For more information, see \link[=skeleton_spec]{?skeleton_spec}.
Setting \code{skeleton=NULL} removes the deterministic skeleton.}

\item{rprior}{optional; prior distribution sampler, specified either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
For more information, see \link[=prior_spec]{?prior_spec}.
Setting \code{rprior=NULL} removes the prior distribution sampler.}

\item{dprior}{optional; prior distribution density evaluator, specified either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
For more information, see \link[=prior_spec]{?prior_spec}.
Setting \code{dprior=NULL} resets the prior distribution to its default, which is a flat improper prior.}

\item{partrans}{optional parameter transformations, constructed using \code{\link{parameter_trans}}.

Many algorithms for parameter estimation search an unconstrained space of parameters.
When working with such an algorithm and a model for which the parameters are constrained, it can be useful to transform parameters.
One should supply the \code{partrans} argument via a call to \code{\link{parameter_trans}}.
For more information, see \link[=parameter_trans]{?parameter_trans}.
Setting \code{partrans=NULL} removes the parameter transformations, i.e., sets them to the identity transformation.}

\item{covar}{optional covariate table, constructed using \code{\link{covariate_table}}.

If a covariate table is supplied, then the value of each of the covariates is interpolated as needed.
The resulting interpolated values are made available to the appropriate basic components.
See the documentation for \code{\link{covariate_table}} for details.}

\item{params}{optional; named numeric vector of parameters.
This will be coerced internally to storage mode \code{double}.}

\item{accumvars}{optional character vector;
contains the names of accumulator variables.
See \link[=accumulators]{?accumulators} for a definition and discussion of accumulator variables.}

\item{obsnames}{optional character vector;
names of the observables.
It is not usually necessary to specify \code{obsnames} since, by default,
these are read from the names of the data variables.}

\item{statenames}{optional character vector;
names of the latent state variables.
It is typically only necessary to supply \code{statenames} when C snippets are in use.}

\item{paramnames}{optional character vector;
names of model parameters.
It is typically only necessary to supply \code{paramnames} when C snippets are in use.}

\item{covarnames}{optional character vector;
names of the covariates.
It is not usually necessary to specify \code{covarnames} since, by default,
these are read from the names of the covariates.}

\item{PACKAGE}{optional character;
the name (without extension) of the external, dynamically loaded library in which any native routines are to be found.
This is only useful if one or more of the model components has been specified using a precompiled dynamically loaded library;
it is not used for any component specified using C snippets.
\code{PACKAGE} can name at most one library.}

\item{globals}{optional character;
arbitrary C code that will be hard-coded into the shared-object library created when  C snippets are provided.
If no C snippets are used, \code{globals} has no effect.}

\item{cdir}{optional character variable.
\code{cdir} specifies the name of the directory within which C snippet code will be compiled.
By default, this is in a temporary directory specific to the \R session.
One can also set this directory using the \code{pomp_cdir} option.}

\item{cfile}{optional character variable.
\code{cfile} gives the name of the file (in directory \code{cdir}) into which C snippet codes will be written.
By default, a random filename is used.
If the chosen filename would result in over-writing an existing file, an error is generated.}

\item{shlib.args}{optional character variables.
Command-line arguments to the \code{R CMD SHLIB} call that compiles the C snippets.}

\item{compile}{logical;
if \code{FALSE}, compilation of the C snippets will be postponed until they are needed.}

\item{verbose}{logical; if \code{TRUE}, diagnostic messages will be printed to the console.}
}
\value{
The \code{pomp} constructor function returns an object, call it \code{P}, of class \sQuote{pomp}.
\code{P} contains, in addition to the data, any elements of the model that have been specified as arguments to the \code{pomp} constructor function.
One can add or modify elements of \code{P} by means of further calls to \code{pomp}, using \code{P} as the first argument in such calls.
One can pass \code{P} to most of the \pkg{pomp} package methods via their \code{data} argument.
}
\description{
This function constructs a \sQuote{pomp} object, encoding a partially-observed Markov process (\acronym{POMP}) model together with a uni- or multi-variate time series.
As such, it is central to all the package's functionality.
One implements the \acronym{POMP} model by specifying some or all of its \emph{basic components}.
These comprise:
\describe{
\item{rinit,}{which samples from the distribution of the state process at the zero-time;}
\item{rprocess,}{the simulator of the unobserved Markov state process;}
\item{dprocess,}{the evaluator of the probability density function for transitions of the unobserved Markov state process;}
\item{rmeasure,}{the simulator of the observed process, conditional on the unobserved state;}
\item{dmeasure,}{the evaluator of the measurement model probability density function;}
\item{rprior,}{which samples from a prior probability distribution on the parameters;}
\item{dprior,}{which evaluates the prior probability density function;}
\item{skeleton,}{which computes the deterministic skeleton of the unobserved state process;}
\item{partrans,}{which performs parameter transformations.}
}
The basic structure and its rationale are described in the \emph{Journal of Statistical Software} paper, an updated version of which is to be found on the \href{https://kingaa.github.io/pomp/}{package website}.
}
\details{
Each basic component is supplied via an argument of the same name.
These can be given in the call to \code{pomp}, or to many of the package's other functions.
In any case, the effect is the same: to add, remove, or modify the basic component.

Each basic component can be furnished using C snippets, \R functions, or pre-compiled native routine available in user-provided dynamically loaded libraries.
}
\section{Note}{


\strong{It is not typically necessary (or indeed often feasible) to define all of the basic components for any given purpose.
Each \pkg{pomp} algorithm makes use of only a subset of these components.
Any algorithm requiring a component that is not present will generate an error letting you know that you have not provided a needed component.
FIXME }
}

\references{
A. A. King, D. Nguyen, and E. L. Ionides (2016)
Statistical Inference for Partially Observed Markov Processes via the Package \pkg{pomp}.
Journal of Statistical Software 69(12): 1--43.
}
\author{
Aaron A. King
}
