% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cond_logLik.R
\docType{methods}
\name{cond.logLik}
\alias{cond.logLik}
\alias{cond.logLik,missing-method}
\alias{cond.logLik,ANY-method}
\alias{cond.logLik-kalmand_pomp}
\alias{cond.logLik,kalmand_pomp-method}
\alias{cond.logLik-pfilterd_pomp}
\alias{cond.logLik,pfilterd_pomp-method}
\alias{cond.logLik-wpfilterd_pomp}
\alias{cond.logLik,wpfilterd_pomp-method}
\alias{cond.logLik-bsmcd_pomp}
\alias{cond.logLik,bsmcd_pomp-method}
\title{Conditional log likelihood}
\usage{
\S4method{cond.logLik}{kalmand_pomp}(object, ...)

\S4method{cond.logLik}{pfilterd_pomp}(object, ...)

\S4method{cond.logLik}{wpfilterd_pomp}(object, ...)

\S4method{cond.logLik}{bsmcd_pomp}(object, ...)
}
\arguments{
\item{object}{result of a filtering computation}

\item{...}{ignored}
}
\value{
The numerical value of the conditional log likelihood.
Note that some methods compute not the log likelihood itself but instead a related quantity.
To keep the code simple, the \code{cond.logLik} function is nevertheless used to extract this quantity.

When \code{object} is of class \sQuote{bsmcd_pomp} (i.e., the result of a \code{bsmc2} computation), \code{cond.logLik} returns the conditional log \dQuote{evidence} (see \code{\link{bsmc2}}).
}
\description{
The estimated conditional log likelihood from a fitted model.
}
\details{
The conditional likelihood is defined to be the value of the density
of \deqn{Y(t_k) | Y(t_1),\dots,Y(t_{k-1})}{Yk | Y1,\dots,Y(k-1)} evaluated at \eqn{Y(t_k) = y^*_k}{Yk = yk*}.
Here, \eqn{Y(t_k)}{Yk} is the observable process, and \eqn{y^*_k}{yk*} the data, at time \eqn{t_k}.

Thus the conditional log likelihood at time \eqn{t_k} is
\deqn{\ell_k(\theta) = \log f[Y(t_k)=y^*_k \vert Y(t_1)=y^*_1, \dots, Y(t_{k-1})=y^*_{k-1}],}{ell_k(theta)=log f[Yk = yk* | Y1=y1*, \dots, Y(k-1)=y(k-1)*],}
where \eqn{f} is the probability density above.
}
\seealso{
More on particle-filter based methods in \pkg{pomp}: 
\code{\link{bsmc2}()},
\code{\link{eff.sample.size}()},
\code{\link{filter.mean}()},
\code{\link{filter.traj}()},
\code{\link{kalman}},
\code{\link{mif2}()},
\code{\link{pfilter}()},
\code{\link{pmcmc}()},
\code{\link{pred.mean}()},
\code{\link{pred.var}()},
\code{\link{saved.states}()},
\code{\link{wpfilter}()}
}
\concept{particle_filter_methods}
