% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workhorses.R
\docType{methods}
\name{workhorses}
\alias{workhorses}
\title{Workhorse functions for the \pkg{pomp} algorithms.}
\description{
These functions mediate the interface between the user's model and the package algorithms.
They are low-level functions that do the work needed by the package's inference methods.
}
\details{
They include \describe{
\item{\code{\link{rinit}}}{which samples from the initial-state distribution,}
\item{\code{\link{dinit}}}{which evaluates the initial-state density,}
\item{\code{\link{dmeasure}}}{which evaluates the measurement model density,}
\item{\code{\link{rmeasure}}}{which samples from the measurement model distribution,}
\item{\code{\link{emeasure}}}{which computes the expectation of the observed variables conditional on the latent state,}
\item{\code{\link{vmeasure}}}{which computes the covariance matrix of the observed variables conditional on the latent state,}
\item{\code{\link{dprocess}}}{which evaluates the process model density,}
\item{\code{\link{rprocess}}}{which samples from the process model distribution,}
\item{\code{\link{dprior}}}{which evaluates the prior probability density,}
\item{\code{\link{rprior}}}{which samples from the prior distribution,}
\item{\code{\link{skeleton}}}{which evaluates the model's deterministic skeleton,}
\item{\code{\link{flow}}}{which iterates or integrates the deterministic skeleton to yield trajectories,}
\item{\code{\link{partrans}}}{which performs parameter transformations associated with the model.}
}
}
\seealso{
\link[=basic_components]{basic model components},
\link[=elementary_algorithms]{elementary algorithms},
\link[=estimation_algorithms]{estimation algorithms}

More on \pkg{pomp} workhorse functions: 
\code{\link{dinit}()},
\code{\link{dmeasure}()},
\code{\link{dprior}()},
\code{\link{dprocess}()},
\code{\link{emeasure}()},
\code{\link{flow}()},
\code{\link{partrans}()},
\code{\link{pomp-package}},
\code{\link{rinit}()},
\code{\link{rmeasure}()},
\code{\link{rprior}()},
\code{\link{rprocess}()},
\code{\link{skeleton}()},
\code{\link{vmeasure}()}
}
\author{
Aaron A. King
}
\concept{extending the pomp package}
\concept{low-level interface}
\concept{pomp workhorses}
