% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impulse_response.R
\name{iRAM}
\alias{iRAM}
\title{Generate iRAM (impulse response anlaysis metric) from model fit.}
\usage{
iRAM(model.fit, beta, var.number, lag.order = 1, threshold = 0.01,
  boot = FALSE, replication = 200, steps = 100)
}
\arguments{
\item{model.fit}{model fit object generated by lavaan}

\item{beta}{beta matrix for a point estimate}

\item{var.number}{number of variables in the time series}

\item{lag.order}{lag order of the model to be fit}

\item{threshold}{threshold of calculation of recovery time (duration of perturbation), default value is 0.01}

\item{boot}{to bootstrap, default value is FALSE}

\item{replication}{number of replication of bootstrap, default value is 200}

\item{steps}{number of steps of impulse response analysis, default value is 100}
}
\value{
iRAM matrix. Rows represent where the orthognal impulse was given, and columns represent the response. Dimension is var.number by var.number.
}
\description{
Generate iRAM (impulse response anlaysis metric) from model fit.
}
\examples{
\dontshow{
boot.iRAM <- iRAM(model.fit = usemmodelfit,
    beta = NULL,
    var.number = 3,
    lag.order = 1,
    threshold = 0.01,
    boot = TRUE,
    replication = 50, # default replication is 200, reduced to 50 to shorten running time
    steps = 30 # default steps is 100, reduced to 30 to shorten running time
    )
boot.iRAM$mean
}
\donttest{
boot.iRAM <- iRAM(model.fit = usemmodelfit,
    beta = NULL,
    var.number = 3,
    lag.order = 1,
    threshold = 0.01,
    boot = TRUE,
    replication = 200,
    steps = 100
    )
boot.iRAM$mean
}


}
\references{
Lütkepohl, H. (2007). New introduction to multiple time-series analysis. Berlin: Springer.
}
