% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate.R, R/transmute.R
\name{mutate}
\alias{mutate}
\alias{transmute}
\title{Create or transform variables}
\usage{
mutate(.data, ...)

transmute(.data, ...)
}
\arguments{
\item{.data}{A \code{data.frame}.}

\item{...}{Name-value pairs of expressions, each with length \code{1L}. The name of each argument will be the name of a
new column and the value will be its corresponding value. Use a \code{NULL} value in \code{mutate} to drop a variable. New
variables overwrite existing variables of the same name.}
}
\description{
\code{mutate()} adds new variables and preserves existing ones; \code{transmute()} adds new variables and drops existing ones.
Both functions preserve the number of rows of the input. New variables overwrite existing variables of the same name.
}
\examples{
mutate(mtcars, mpg2 = mpg * 2)
mtcars \%>\% mutate(mpg2 = mpg * 2)
mtcars \%>\% mutate(mpg2 = mpg * 2, cyl2 = cyl * 2)

# Newly created variables are available immediately
mtcars \%>\% mutate(mpg2 = mpg * 2, mpg4 = mpg2 * 2)

# You can also use mutate() to remove variables and modify existing variables
mtcars \%>\% mutate(
  mpg = NULL,
  disp = disp * 0.0163871 # convert to litres
)

# mutate() vs transmute --------------------------
# mutate() keeps all existing variables
mtcars \%>\%
  mutate(displ_l = disp / 61.0237)

# transmute keeps only the variables you create
mtcars \%>\%
  transmute(displ_l = disp / 61.0237)

}
