% Generated by roxygen2 (4.0.1): do not edit by hand
\name{integrate2}
\alias{integrate2}
\title{Evaluate integral}
\usage{
integrate2(limit.vec = c(-3, 3), theta.diff, sigma.2 = 1, n = 1)
}
\arguments{
\item{limit.vec}{This is a vector of length 2. It consists of the lower and
upper limits in the integral. Checking is carried out to ensure that is of
length two, and that limit.vec[1] <= limit.vec[2].}

\item{theta.diff}{A vector of length p-1, where p is the number of populations
of treatments. Coordinate [i] in theta.diff corresponds to \eqn{\theta_i -
\theta_{i+1}}. See \code{\link{genDelMat}}.}

\item{sigma.2}{The known variance of the error terms.}

\item{n}{The number of replications per population.}
}
\value{
The function returns a scalar value that is the value of the integral
in equation (4) of page 7, defined by the lower and upper limits provided
here.
}
\description{
This function will evaluate the integral in equation
(4) on page 7 of the paper. See Details section.
}
\details{
This function evaluates the integral, and works with the lower and
upper limits that it is given. If one desires to compute the coverage
probability for an interval defined by \eqn{X_{(1)} \pm c}, then the user should
look at the function \link{exactCoverageProb} in this package.
}
\examples{
del1 <- c(2, 4)
integrate2(c(-1.1,1.3), del1)
}
\seealso{
\link{exactCoverageProb}, \link{integrand}
}

