% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPopkin.R
\name{plotPopkin}
\alias{plotPopkin}
\title{Visualize one or more kinship matrices}
\usage{
plotPopkin(x, titles = NULL, col = NULL, colCont = FALSE,
  coln = 100, xMar = NULL, marPad = 0.2, diagLine = FALSE,
  panelLetters = toupper(letters), panelLetterCex = 1.5,
  ylab = "Individuals", ylabAdj = NA, ylabLine = 0,
  addLayout = TRUE, nr = 1, legTitle = "Kinship", legMar = NULL,
  nPretty = 5, showNames = FALSE, namesCex = 1, namesLine = NA,
  labs = NULL, labsCex = 1, labsLas = 0, labsLine = 0,
  labsSkipLines = FALSE, labsLwd = 1, labsCol = "black",
  labsDoTicks = FALSE, labsDoText = TRUE, labsEven = FALSE, ...)
}
\arguments{
\item{x}{A numeric kinship matrix or a list of matrices.  Note \code{x} may contain \code{NULL} elements (makes blank plots with titles; good for placeholders or non-existent data)}

\item{titles}{Titles to add to each matrix panel (default is no titles)}

\item{col}{Colors for heatmap (default is a red-white-blue palette symmetric about zero constructed using RColorBrewer).}

\item{colCont}{If \code{TRUE} then \code{coln} colors will be used in the palette, otherwise (default) only 17 colors are used (those obtained directly from RColorBrewer).  A large value of \code{coln} will give the appearance of continuous colors.}

\item{coln}{The number of colors to use in the heatmap if \code{colCont==TRUE}.}

\item{xMar}{Margins for each panel (if a list) or for all panels (if a vector).  Margins are in \code{c(bottom,left,top,right)} format that \code{\link[graphics]{par}('mar')} expects.  Note the padding \code{marPad} below is also added to every margin if set.  By default the existing margin values are used without change}

\item{marPad}{Margin padding added to all panels (\code{xMar} above and \code{legMar} below).  Default 0.2.  Must be a scalar or a vector of length 4 to match \code{\link[graphics]{par}('mar')}.}

\item{diagLine}{If \code{TRUE} adds a line along the diagonal (default no line).  May also be a vector of booleans to set per panel (lengths must agree)}

\item{panelLetters}{Vector of strings for labeling panels (default A-Z).  No labels are added when there is only one panel, or if `panelLetters=NULL`}

\item{panelLetterCex}{Scaling factor of panel letters (default 1.5)

AXIS LABEL OPTIONS}

\item{ylab}{The y-axis label (default "Individuals").  If \code{length(ylab)==1}, the label is placed in the outer margin (shared across panels); otherwise \code{length(ylab)} must equal the number of panels and each label is placed in the inner margin of the respective panel}

\item{ylabAdj}{The value of "adj" passed to \code{\link[graphics]{mtext}}.  If \code{length(ylab)==1}, only the first value is used, otherwise \code{length(ylabAdj)} must equal the number of panels}

\item{ylabLine}{The value of "line" passed to \code{\link[graphics]{mtext}}.  If \code{length(ylab)==1}, only the first value is used, otherwise \code{length(ylabLine)} must equal the number of panels

LAYOUT OPTIONS}

\item{addLayout}{If \code{TRUE} (default) then \code{\link[graphics]{layout}} is called internally with appropriate values for the required number of panels for each matrix, the desired number of rows (see \code{nr} below) plus the color key legend.  Set to FALSE and call \code{\link[graphics]{layout}} beforehand if a non-standard layout or additional panels (beyond those provided by \code{plotPopkin}) are desired.}

\item{nr}{Number of rows in layout, used only if \code{addLayout=TRUE}

LEGEND (COLOR KEY) OPTIONS}

\item{legTitle}{The name of the variable that the heatmap colors measure (default "Kinship")}

\item{legMar}{Margin vector (in \code{c(bottom,left,top,right)} format that \code{\link[graphics]{par}('mar')} expects) for the legend panel only.  If not provided, the margins used in the last panel are preserved with the exception that the left margin is set to zero (plus the value of \code{marPad}, see above).}

\item{nPretty}{The desired number of ticks in the legend y-axis (input to \code{\link{pretty}}, see that for more details)

INDIVIDUAL LABEL OPTIONS}

\item{showNames}{If \code{TRUE}, the column and row names are plotted in the heatmap}

\item{namesCex}{Scaling factor for the column and row names}

\item{namesLine}{Line where column and row names are placed

SUBPOPULATION LABEL OPTIONS}

\item{labs}{Subpopulation labels for individuals.  Use a matrix of labels to show groupings at more than one level (for a hierarchy or otherwise).  If input is a vector or a matrix, the same subpopulation labels are shown for every heatmap panel; the input must be a list of such vectors or matrices if the labels vary per panel}

\item{labsCex}{A vector of label scaling factors for each level of labs, or a list of such vectors if labels vary per panel}

\item{labsLas}{A vector of label orientations (in format that \code{\link[graphics]{mtext}} expects) for each level of labs, or a list of such vectors if labels vary per panel}

\item{labsLine}{A vector of lines where labels are placed (in format that \code{\link[graphics]{mtext}} expects) for each level of labs, or a list of such vectors if labels vary per panel}

\item{labsSkipLines}{A vector of booleans that specify whether lines separating the subpopulations are drawn for each level of labs, or a list of such vectors if labels vary per panel}

\item{labsLwd}{A vector of line widths for the lines that divide subpopulations (if \code{labsSkipLines=FALSE}) for each level of labs, or a list of such vectors if labels vary per panel}

\item{labsCol}{A vector of colors for the lines that divide subpopulations (if \code{labsSkipLines=FALSE}) for each level of labs, or a list of such vectors if labels vary per panel}

\item{labsDoTicks}{A vector of booleans that specify whether ticks separating the subpopulations are drawn for each level of labs, or a list of such vectors if labels vary per panel}

\item{labsDoText}{A vector of booleans that specify whether the subpopulation labels are shown for each level of labs, or a list of such vectors if labels vary per panel.  Useful for including separating lines or ticks without text.}

\item{labsEven}{A vector of booleans that specify whether the subpopulations labels are drawn with equal spacing for each level of labs, or a list of such vectors if labels vary per panel.  When \code{TRUE}, lines mapping the equally-spaced labels to the unequally-spaced subsections of the heatmap are also drawn}

\item{...}{Additional options passed to \code{\link[graphics]{image}}.  These are shared across panels}
}
\description{
This function plots one or more kinship matrices and a shared legend for the color key.
Many options allow for fine control of individual or subpopulation labeling.
}
\details{
\code{plotPopkin} plots the input kinship matrices as-is.
For best results, a standard kinship matrix (such as the output of \code{\link{popkin}}) should have its diagonal rescaled to contain inbreeding coefficients (\code{\link{inbrDiag}} does this) before \code{plotPopkin} is used.

This function permits the labeling of individuals (from row and column names when \code{showNames=TRUE}) and of subpopulations (passed through \code{labs}).
The difference is that the labels passed through \code{labs} are assumed to be shared by many individuals, and lines (or other optional visual aids) are added to demarcate these subgroups.

For flexibility, this function will work for non-symmetric and even non-square matrices, even though proper kinship matrices are both.
For non-symmetric inputs, differing rownames and colnames will display correctly (if \code{showNames==TRUE}).
However, numerous options implicitly assume symmetry.
For example, only the y-axis is labeled under the assumption that the x-axis is the same.
Also, the same subpopulation labels are reproduced on both axes (for clarity).
}
\examples{
## Construct toy data
X <- matrix(c(0,1,2,1,0,1,1,0,2), nrow=3, byrow=TRUE) # genotype matrix
subpops <- c(1,1,2) # subpopulation assignments for individuals

## NOTE: for BED-formatted input, use BEDMatrix!
## "file" is path to BED file (excluding .bed extension)
# library(BEDMatrix)
# X <- BEDMatrix(file) # load genotype matrix object

## estimate the kinship matrix "Phi" from the genotypes "X"!
Phi <- popkin(X, subpops) # calculate kinship from X and optional subpop labels

## simple plot of the kinship matrix, marking the subpopulations only
## note inbrDiag replaces the diagonal of Phi with inbreeding coefficients
## (see vignette for more elaborate examples)
plotPopkin( inbrDiag(Phi), labs=subpops )

}
