% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popkin_A.R
\name{popkin_A}
\alias{popkin_A}
\title{Compute popkin's \code{A} and \code{M} matrices from genotypes}
\usage{
popkin_A(
  X,
  n = NA,
  loci_on_cols = FALSE,
  mem_factor = 0.7,
  mem_lim = NA,
  m_chunk_max = 1000
)
}
\arguments{
\item{X}{Genotype matrix, BEDMatrix object, or a function \code{X(m)} that returns the genotypes of all individuals at \code{m} successive locus blocks each time it is called, and \code{NULL} when no loci are left.
If a regular matrix, \code{X} must have values only in \code{c(0, 1, 2, NA)}, encoded to count the number of reference alleles at the locus, or \code{NA} for missing data.}

\item{n}{Number of individuals (required only when \code{X} is a function, ignored otherwise).
If \code{n} is missing but \code{subpops} is not, \code{n} is taken to be the length of \code{subpops}.}

\item{loci_on_cols}{If \code{TRUE}, \code{X} has loci on columns and individuals on rows; if \code{FALSE} (default), loci are on rows and individuals on columns.
Has no effect if \code{X} is a function.
If \code{X} is a BEDMatrix object, \code{loci_on_cols} is ignored (set automatically to \code{TRUE} internally).}

\item{mem_factor}{Proportion of available memory to use loading and processing genotypes.
Ignored if \code{mem_lim} is not \code{NA}.}

\item{mem_lim}{Memory limit in GB, used to break up genotype data into chunks for very large datasets.
Note memory usage is somewhat underestimated and is not controlled strictly.
Default in Linux and Windows is \code{mem_factor} times the free system memory, otherwise it is 1GB (OSX and other systems).}

\item{m_chunk_max}{Sets the maximum number of loci to process at the time.
Actual number of loci loaded may be lower if memory is limiting.}
}
\value{
A named list containing:
\itemize{
\item \code{A}: n-by-n matrix, for individuals \code{j} and \code{k}, of average \code{( x_ij - 1 ) * ( x_ik - 1 ) - 1} values across all loci \code{i} in \code{X}
\item \code{M}: n-by-n matrix of sample sizes (number of loci with non-missing individual \code{j} and \code{k} pairs, used to normalize \code{A})
}
}
\description{
This function returns lower-level, intermediate calculations for the main \code{popkin} function.
These are not intended for most users, but rather for researchers studying the estimator.
}
\examples{
# Construct toy data
X <- matrix(c(0,1,2,1,0,1,1,0,2), nrow = 3, byrow = TRUE) # genotype matrix

# NOTE: for BED-formatted input, use BEDMatrix!
# "file" is path to BED file (excluding .bed extension)
# library(BEDMatrix)
# X <- BEDMatrix(file) # load genotype matrix object

obj <- popkin_A(X) # calculate A and M from genotypes
A <- obj$A
M <- obj$M

}
\seealso{
The main \code{\link[=popkin]{popkin()}} function (a wrapper of this \code{popkin_A} function and \code{\link[=popkin_A_min_subpops]{popkin_A_min_subpops()}} to estimate the minimum \code{A} value).
}
