% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/risk_measures.R
\name{est_var}
\alias{est_var}
\title{Estimate the Value at Risk (VaR)}
\usage{
est_var(sample, alpha)
}
\arguments{
\item{sample}{Numeric vector representing the sample upon which the Value at
Risk is calculated.}

\item{alpha}{Numeric vector with entries in (0,1) specifying the levels at
which the VaR is calculated.}
}
\value{
Numeric vector with VaR estimates
(same length as \code{alpha}).
}
\description{
The VaR is defined as the empirical \eqn{\alpha} level quantile of the
empirical distribution based on a return sample.
}
\examples{
est_var(0:100, c(0.1, 0.2, 0.3))
}
\seealso{
\code{\link[=est_es]{est_es()}}
}
