% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BinaryVariablePOSet.R
\name{BinaryVariablePOSet}
\alias{BinaryVariablePOSet}
\title{Constructing a component-wise poset of binary vectors.}
\usage{
BinaryVariablePOSet(variables)
}
\arguments{
\item{variables}{A vector of character strings (the names of the input binary variables).}
}
\value{
An object of S4 class \code{BinarVariablePOSet} (subclass of \code{POSet}).
}
\description{
Constructs a component-wise poset, starting from a collection of binary variables.
}
\details{
Given \eqn{k} input binary variables, the function produces a poset \eqn{(V,\leq_{cmp})}, where \eqn{V} is the set of \eqn{2^k} binary vectors built from the variables, and \eqn{\leq_{cmp}} is the component-wise order.
}
\examples{
vrbs <- c("var1", "var2", "var3")
binPoset <-  BinaryVariablePOSet(variables = vrbs)

}
