% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{rockjock}
\alias{rockjock}
\title{RockJock reference library}
\format{
A powdRlib object of 3 components
\describe{
\item{xrd}{A dataframe of all the count intensities of all reference patterns. Column names denote the
unique phase ID of each reference pattern}
\item{tth}{A vector of the 2theta scale for all reference patterns in the library}
\item{phases}{A dataframe the phase IDs, names and reference intensity
ratios (RIR)}
}
}
\usage{
rockjock
}
\description{
A \code{powdRlib} object of 168 pure reference patterns from the RockJock
library (Cu K-alpha radiation) along with reference intensity ratios. Note that compared
to same library supplied with RockJock the powdR patterns have been normalised to 10,000
counts and reference intensity ratios transformed so that all are relative
to that of corundum, which has been set to a value of 1.0.
Can be used with the \code{fps()} and \code{afps()} functions for quantitative
analysis. Example mixtures for testing the \code{rockjock} library with known
concentrations are available in the \code{rockjock_mixtures} data. See
\code{?rockjock_mixtures}.
}
\references{
Eberl, D.D., 2003. User's guide to RockJock - A program for determining quantitative mineralogy from
powder X-ray diffraction data. Boulder, CA.
}
\author{
Dennis Eberl
}
\keyword{datasets}
