% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_data}
\alias{simulate_data}
\alias{simulate_data.plcp}
\alias{simulate_data.plcp_multi}
\title{Generate a data set using a \code{study_parameters}-object}
\usage{
simulate_data(paras, n = 1)

\method{simulate_data}{plcp}(paras, n = NULL)

\method{simulate_data}{plcp_multi}(paras, n = 1)
}
\arguments{
\item{paras}{An object created by \code{\link{study_parameters}}}

\item{n}{Optional; specifies which row \code{n} should be used if \code{object}
is a \code{data.frame} containing multiple setups.}
}
\value{
A \code{data.frame} with the simulated data in long form. With the following columns:
\itemize{
 \item \code{y} the outcome vector, with missing values as NA
 \item \code{y_c} the outcome vector, without missing values removed.
 \item \code{time} the time vector
 \item \code{treatment} treatment indicator (0 = "control", 1 = "treatment")
 \item \code{subject} subject-level id variable, from 1 to total number of subjects.
 \item \code{cluster} for three-level models; the cluster-level id variable,
 from 1 to the total number of clusters.
}
}
\description{
Generate a data set using a \code{study_parameters}-object
}
\examples{
p <- study_parameters(n1 = 11,
                      n2 = 10,
                      n3 = 4,
                      T_end = 10,
                      fixed_intercept = 37,
                      fixed_slope = -0.65,
                      sigma_subject_intercept = 2.89,
                      sigma_cluster_intercept = 0.6,
                      icc_slope = 0.1,
                      var_ratio = 0.03,
                      sigma_error = 1.5,
                      cor_subject = -0.5,
                      cor_cluster = 0,
                      cohend = 0.5)

d <- simulate_data(p)
}
