\name{plotNtdt}
\alias{plotNtdt}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ A function for plotting the results from ntdt.q } 
\description{ This function plots the results from ntdt.q

}
\usage{
plotNtdt(g, m, alpha = 5e-08, power = 0.8,...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{g}{ the genotype risk ratio for the susceptibility gene }
  \item{m}{ the frequency of the marker allele in linkage disequilibrium
with the susceptibility allele. }
  \item{alpha}{  the Type 1 error rate }
  \item{power}{ the desired power }
  \item{...}{additional arguments for plot }
}
\details{
We will use an R program that implements the power formulae of Abel
and Muller-Myhsok (1998). These formulae allow one to quickly compute
power of the TDT approach under a variety of different conditions. This
R program was modeled on Martin Farrall's Mathematica notebook.

The power computations here use a simple genetic model with several
aspects: (1) The disease locus has two alleles, A and a, with allele
frequencies q and 1-q. The risk of disease follows a multiplicative
model with genotype relative risks of g and g*g for the A/a and A/A
subjects. (2) There is a perfectly linked marker with two alleles,
with allele frequencies m and 1-m.
}
\value{
  A plot of the results generated by a call to the ntdt.q() function.
}
\references{ 
Abel L, Muller-Myhsok B. Maximum-likelihood expression of the
transmission/disequilibrium test and power considerations. Am J Hum
Genet. 1998 Aug;63(2):664-7.

Chen WM, Deng HW. A general and accurate approach for computing the
statistical power of the transmission disequilibrium test for complex
disease genes. Genet Epidemiol. 2001 Jul;21(1):53-67.

Iles MM. On calculating the power of a TDT study--comparison of
methods. Ann Hum Genet. 2002 Jul;66(Pt 4):323-8.

Purcell S, Cherny SS, Sham PC. Genetic Power Calculator: design
of linkage and association genetic mapping studies of complex
traits. Bioinformatics. 2003 Jan;19(1):149-50.
}

\author{ Daniel E. Weeks } 
\note{ This R program was modeled on Martin
Farrall's Mathematica notebook. }


\seealso{ \code{\link{ntdt}}, \code{\link{ntdt.q}} }

\examples{
## Duplicate Figures 1 and 2 from Abel and Muller-Myhsok (1998)
## Am J Hum Genet 63:664-667
plotNtdt(g=2,m=0.10) 
## gives Figure 1A
plotNtdt(g=2,m=0.50) 
## gives Figure 1B
}
\keyword{ models }
