% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nodeEstimate.R
\name{nodeEstimate}
\alias{nodeEstimate}
\title{nodeEstimate}
\usage{
nodeEstimate(treedata.obj, traitnum, model = "BM", bounds = list(), 
control = list(), plot.est = FALSE)
}
\arguments{
\item{treedata.obj}{an object of the class "treedata".}

\item{traitnum}{the column number of the trait within the treedata object to be reconstructed.}

\item{model}{the model of evolution to use in the ancestral state reconstruction. Options are "estimate", "BM", "OU", "EB", "lambda", "kappa", "delta".}

\item{bounds}{bounds used for the model, passes to \code{fitContinuous()}, uses default if none specified.}

\item{control}{setting used for optimization of the model likelihood. Passes to \code{fitContinuous()}.}

\item{plot.est}{logical. whether or not to plot the traitgram of the estimated ancestor states.}
}
\value{
an object of the class "nodeEstimate".

\code{model}    if model = "estimate", the best fit model of evolution. If the model was specified, then model is the specified model.

\code{est}      the ancestral node estimates of the continuous character.

\code{phy}      the phylogeny used for the estimates, which might be transformed depending on the evolutionary model.

\code{BM}       if model = "BM", returned values from \code{fitContinuous()} where the model is "BM"

\code{OU}       if model = "OU", returned values from \code{fitContinuous()} where the model is "OU"

\code{EB}       if model = "EB", returned values from \code{fitContinuous()} where the model is "EB"

\code{lambda}   if model = "lambda", returned values from \code{fitContinuous()} where the model is "lambda"

\code{kappa}    if model = "kappa", returned values from \code{fitContinuous()} where the model is "kappa"

\code{delta}    if model = "delta", returned values from \code{fitContinuous()} where the model is "delta"

\code{fitted}   if model = "estimate", returned values from the best fit model of evolution.
}
\description{
This function estimates the ancestral character states for continuous characters given a model of evolution or using the best fit model of evolution from the fitContinuous function in the geiger package. The ancestral states are estimated using GLS described in Martins and Hansen (1997).
}
\details{
See the \code{fitContinuous()} details for descriptions of the models of evolution and parameter estimation. \code{nodeEstimate()} currently supports the following models of evolution: Brownian motion (Felsenstein, 1973), Ornstein-Uhlenbeck (Butler and King, 2004), early-burst (Harmon et al., 2010), lambda (Pagel, 1999), kappa (Pagel, 1999), and delta (Pagel, 1999).
}
\examples{
data(sampletrees)
data(occurrences)
occurrences <- getBioclimVars(occurrences, which.biovars=1)
sp_data_min<- tapply(occurrences[,4],occurrences$Species,min)
ex <- geiger::treedata(sampletrees[[1]], sp_data_min)
\donttest{nodeEstimate(ex, 1, model = 'OU')} #runs OU model
}
\references{
Butler, M. A. and King, A. A. (2004) Phylogenetic comparative analysis: a modeling approach for adaptive evolution. American Naturalist, 164:683-695.

Felsenstein, J. (1973) Maximum likelihood estimation of evolutionary trees from continuous characters. American Journal of Human Genetics, 25:471-492

Harmon, L. J. et al. (2010) Early bursts of body size and shape evolution are rare in comparative data. Evolution, 64:2385-2396

Martins, E. P. and Hansen, T. F. (1997) Phylogenies and the comparative method: a general approach to incorporating phylogenetic information into the analysis of interspecific data. American Naturalist, 149, 646–667.

Pagel M. (1999) Inferring the historical patterns of biological evolution. Nature, 401:877-884
}
\seealso{
\code{fitContinuous()}
}
\author{
A. Michelle Lawing, Alexandra F. C. Howard
}
