% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output.R
\name{modelSelection_Q}
\alias{modelSelection_Q}
\title{Selects the number of groups with ICL}
\usage{
modelSelection_Q(data, n, Qmin = 1, Qmax, directed = TRUE, sparse = FALSE,
  sol.hist.sauv)
}
\arguments{
\item{data}{List with 2 components:
\itemize{
  \item $Time - [0,data$Time] is the total time interval of observation
  \item $Nijk - data matrix with the statistics per process \eqn{N_{ij}} and sub-intervals \eqn{k}
}}

\item{n}{Total number of nodes \eqn{n}}

\item{Qmin}{Minimum number of groups}

\item{Qmax}{Maximum number of groups}

\item{directed}{Boolean for directed (TRUE) or undirected (FALSE) case}

\item{sparse}{Boolean for sparse (TRUE) or not sparse (FALSE) case}

\item{sol.hist.sauv}{List of size Qmax-Qmin+1 obtained from running mainVEM(data,n,Qmin,Qmax,method='hist')}
}
\description{
Selects the number of groups with Integrated Classification Likelihood Criterion
}
\examples{
# load data of a synthetic graph with 50 individuals and 3 clusters
n <- 50

# compute data matrix with precision d_max=3
Dmax <- 2^3
data <- list(Nijk=statistics(generated_Q3$data,n,Dmax,directed=FALSE),
    Time=generated_Q3$data$Time)

# ICL-model selection
sol.selec_Q <- modelSelection_Q(data,n,Qmin=1,Qmax=4,directed=FALSE,
    sparse=FALSE,generated_sol_hist)

# best number Q of clusters:
sol.selec_Q$Qbest

}
\references{
BIERNACKI, C., CELEUX, G. & GOVAERT, G. (2000). Assessing a mixture model for clustering with the integrated completed likelihood. IEEE Trans. Pattern Anal. Machine Intel. 22, 719–725.

CORNELI, M., LATOUCHE, P. & ROSSI, F. (2016). Exact ICL maximization in a non-stationary temporal extension of the stochastic block model for dynamic networks. Neurocomputing 192, 81 – 91.

DAUDIN, J.-J., PICARD, F. & ROBIN, S. (2008). A mixture model for random graphs. Statist. Comput. 18, 173–183.

MATIAS, C., REBAFKA, T. & VILLERS, F. (2018).  A semiparametric extension of the stochastic block model for longitudinal networks. Biometrika.
}
