% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialization.R
\name{taurhoInitial}
\alias{taurhoInitial}
\title{Sparse setup - \eqn{\rho} parameter}
\usage{
taurhoInitial(tau, data, n, Q, directed = TRUE)
}
\arguments{
\item{tau}{\eqn{\tau}}

\item{data}{Data : only needs the \eqn{N_{ijk}} field of data}

\item{n}{Total number of nodes}

\item{Q}{Total number of groups}

\item{directed}{Boolean for directed (TRUE) or undirected (FALSE) case}
}
\value{
Both \eqn{\tau} and \eqn{\rho}.
}
\description{
Sparse setup - \eqn{\rho} parameter
}
\examples{
# Generate first initial tau for generated_Q3 data

n <- 50
Dmax <- 2^3
Q <- 3
d_part <- 1 # less than 3 (owing to Dmax)
n_perturb <- 2
perc_perturb <- 0.2
n_random <- 1
directed <- FALSE

data <- list(Nijk = statistics(generated_Q3$data, n, Dmax, directed = FALSE))

tau <- tauInitial(data,n,Q,d_part,n_perturb,perc_perturb,n_random,directed)

taurho <- taurhoInitial(tau[[1]],data,n,Q,directed=FALSE)

}
