% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssim.distri.R
\name{ssim.distri}
\alias{ssim.distri}
\title{Self-similar distribution}
\usage{
ssim.distri(M_ref, n, sd = 0.02, f = 1)
}
\arguments{
\item{M_ref}{a k x 2 refence matrix (usually the sample mean shape), where k is the number of 2D landmarks}

\item{n}{the number of observations}

\item{sd}{the standard deviation of the distribution (default = 0.02)}

\item{f}{a scaling factor}
}
\value{
the n x 2k matrix of shape coordinates drawn from a self-similar distribution
}
\description{
Create a matrix of 2D shape coordinates drawn from a self-similar distribution (3D not implemented)
}
\examples{
# 2D landmark coordinates
library("geomorph")
data("HomoMidSag")  # dataset
n_spec <- dim(HomoMidSag)[1]  # number of specimens
k <- dim(HomoMidSag)[2] / 2  # number of landmarks
homo_ar <- arrayspecs(HomoMidSag, k, 2)  # create an array

# Procrustes registration
homo_gpa <- Morpho::procSym(homo_ar)
m_mshape <- homo_gpa$mshape  # average shape

# Self-similar distribution
Xdefl <- ssim.distri(m_mshape, n = n_spec, sd = 0.05, f = 1)
# Visualization
plot(Xdefl[, 1:k], Xdefl[, (k+1):(2*k)], asp = 1, las = 1, cex = 0.5,
main = "Self-similar distribution", xlab = "X", ylab = "Y")

}
