% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pitchplot.R
\name{pitchplot}
\alias{pitchplot}
\title{Plot pitch object}
\usage{
pitchplot(
  pt,
  start,
  end,
  tfrom0 = TRUE,
  tgbool = FALSE,
  lines = NULL,
  focusTierColor = "black",
  focusTierLineType = "dotted",
  plotType = "draw",
  scale = "hz",
  freqRange = NULL,
  semitonesRe = 100,
  color = "black",
  ind = NULL,
  min_max_only = TRUE,
  axisLabel = NULL,
  drawSize = 1,
  speckleSize = 1
)
}
\arguments{
\item{pt}{PitchTier object loaded using \link[rPraat:pt.read]{rPraat::pt.read}}

\item{start}{Start time (in seconds) of desired plotted area.}

\item{end}{End time (in seconds) of desired plotted area.}

\item{tfrom0}{Logical; should time on the x-axis run from 0 or from the
original time? Default is \code{TRUE}.}

\item{tgbool}{Logical; should dotted lines be plotted corresponding to
locations in a TextGrid? Default is \code{FALSE}.}

\item{lines}{Numeric vector giving locations in seconds of locations from
a TextGrid to be plotted with dotted lines. Default is \code{NULL}.}

\item{focusTierColor}{String or vector of strings giving the color(s) to
use for plotting focus tier lines. If multiple tiers are focused, a vector
of the same length can be passed, and the nth tier will be plotted in the
nth color. Default is \code{'black'}.}

\item{focusTierLineType}{String or vector of strings giving the line
type(s) for plotting focus tier lines. If multiple tiers are focused, a
vector of the same length can be passed, and the nth tier will be plotted in
the nth line type. Default is \code{'dotted'}.}

\item{plotType}{String giving the type of pitch plot to produce; default
is \code{draw} (a line plot), the only other option is \code{speckle} (a point plot).
Alternatively a vector \code{c('draw','speckle')} can be passed, in which case
both are used.}

\item{scale}{String giving the frequency scale to use when producing
pitch plots. Default is \code{hz}; other options are \code{logarithmic} (also in Hz),
\code{semitones}, \code{erb}, and \code{mel}.}

\item{freqRange}{Vector of two integers giving the frequency range to be
used for producing pitch plots. Default is \code{NULL}, in which case the pitch
range is automatically reset to \code{c(-12,30)} for the \code{semitones} scale,
\code{c(0,10)} for the \code{erb} scale, and \code{c(50,500)} for the Hz-based scales,
following Praat defaults.}

\item{semitonesRe}{Frequency in Hz giving the reference level for converting
pitch frequency to semitones. Default is \code{100}.}

\item{color}{String giving the name of the color to be used for
plotting pitch. Default is \code{'black'}.}

\item{ind}{Integer indexing waveform relative to other plot components.
Default is \code{NULL}.}

\item{min_max_only}{Logical; should only minimum and maximum values be given
on the y-axis? Default is \code{TRUE}. Can also be a logical vector if some but
not all plot components should have minimum and maximum values on the y-axis.
Ignored for TextGrid component.}

\item{axisLabel}{String giving the name of the label to print along the
y-axis when printing a pitch track. Default is \code{NULL}, in which case the
axis label will depend on the scale.}

\item{drawSize}{Number indicating the line width if
\code{plotType} is \code{'draw'}. Default is \code{1}. Controls the \code{lwd} argument of
\link[graphics:lines]{graphics::lines}.}

\item{speckleSize}{Number indicating the point size of if \verb{_plotType} is
\code{'speckle'}. Default is \code{1}. Controls the \code{cex} arguments of
\link[graphics:points]{graphics::points}.}
}
\value{
No return values, called internally by \link{praatpicture} and sibling
functions.
}
\description{
Function for plotting pitch objects called by \link{praatpicture}. Instead of
using this function directly, just use
\code{praatpicture('my_sound_file', frames='pitch')}.
}
\examples{
# Don't use directly
datapath <- system.file('extdata', package='praatpicture')
soundFile <- paste0(datapath, '/1.wav')
praatpicture(soundFile, frames='pitch')
}
