% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool_zzz.R
\docType{class}
\name{ToolPRROC}
\alias{ToolPRROC}
\title{R6 class of the PRROC tool}
\format{An R6 class object.}
\usage{
ToolPRROC
}
\description{
\code{ToolPRROC} is a wrapper class for
the \href{https://cran.r-project.org/package=PRROC}{PRROC} tool, which
is an R library that provides calculations of ROC and Precision-Recall
curves.
}
\section{Inheritance}{

\code{\link{ToolIFBase}}
}

\section{Methods}{

\describe{
  \item{\code{set_curve(val)}}{A Boolean value to specify whether a
                               Precision-Recall curve is calculated.}
  \item{\code{set_minStepSize(val)}}{A numeric value to specify the minimum
                                     step size between two intermediate
                                     points.}
}

Following eight methods are inherited from \code{\link{ToolIFBase}}. See
\code{\link{ToolIFBase}} for the method descriptions.
\itemize{
  \item \code{call(testset, calc_auc, store_res)}
  \item \code{get_toolname()}
  \item \code{get_setname()}
  \item \code{set_setname(setname)}
  \item \code{get_result()}
  \item \code{get_x()}
  \item \code{get_y()}
  \item \code{get_auc()}
}
}
\examples{
## Initialization
toolprroc <- ToolPRROC$new()

## Show object info
toolprroc

## create_toolset should be used for benchmarking and curve evaluation
toolprroc2 <- create_toolset("PRROC")

}
\seealso{
This class is derived from \code{\link{ToolIFBase}}.
   \code{\link{create_toolset}} for creating a list of tools.
}
\keyword{datasets}

