% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_zzz.R
\docType{class}
\name{TestDataC}
\alias{TestDataC}
\title{R6 class of test dataset for Precision-Recall curve evaluation}
\format{An R6 class object.}
\usage{
TestDataC
}
\description{
\code{TestDataC} is a class that contains scores and label for performance
  evaluation tools. It provides necessary methods for curve evaluation.
}
\section{Methods}{

\itemize{
 \item \code{set_basepoints_x(x)}: Set pre-calculated recall values for
   curve evaluation
 \item \code{set_basepoints_y(y)}: Set pre-calculated precision values for
   curve evaluation
 \item \code{get_basepoints_x()}: Get pre-calculated recall values for
   curve evaluation
 \item \code{get_basepoints_y()}: Get pre-calculated precision values for
   curve evaluation
 \item \code{set_textpos_x(x)}: Set the x position for displaying the test
   result in a plot
 \item \code{set_textpos_y(y)}: Set the y position for displaying the test
   result in a plot
 \item \code{get_textpos_x()}: Get the x position for displaying the test
   result in a plot
 \item \code{get_textpos_y()}: Get the y position for displaying the test
   result in a plot
}

Following seven methods are inherited from \code{\link{TestDataB}}. See
\code{\link{TestDataB}} for the method descriptions.
\itemize{
  \item \code{get_datname()}
  \item \code{get_scores()}
  \item \code{get_labels()}
  \item \code{get_fg()}
  \item \code{get_bg()}
  \item \code{get_fname()}
  \item \code{del_file()}
}
}

\examples{
## Initialize with scores, labels, and a dataset name
testset <- TestDataC$new(c(0.1, 0.2), c(1, 0), "c4")
testset

## Set base points
testset$set_basepoints_x(c(0.13, 0.2))
testset$set_basepoints_y(c(0.5, 0.6))
testset

}
\seealso{
\code{\link{create_testset}} for creating a list of test datasets.
  It is derived from \code{\link{TestDataB}}.
}
\keyword{datasets}
