% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_predatory.R
\name{find.predatory}
\alias{find.predatory}
\title{Checks if an issn, name of journal or publisher is registered in Beall's list of predatory journals and publishers}
\usage{
find.predatory(x, by = "name", type.match = "partial", quiet = F)
}
\arguments{
\item{x}{A name or issn for full or partial matching. For the later, the format is XXXX-XXXX. The input is insensitive to capslock.}

\item{by}{Defines whether to look for x in the names or issn of journals (possible values = c('name','issn'))}

\item{type.match}{Defines if the function will perform a full or partial match lookup (possible values = c('full','partial'))}

\item{quiet}{Logical, defines whether to print results to screen or not}
}
\value{
A dataframe with the matched issn or name
}
\description{
This function takes as input a name or issn and looks for a match in a database of predatory journals from Beall's list (https://scholarlyoa.com/).
The function can find a name or issn of a particular journal with perfect of partial match. A shiny app is also available (https://msperlin.shinyapps.io/shiny-predatory/).
}
\section{Warning}{


While the database for standalone journals is up to date, the information about predatory publishers is not yet complete since it requires
an extensive manual work. The missing data will be regularly included in the upcoming versions of the package. Last update: 2016-12-09.
}

\examples{
my.name <- 'finance'

out <- find.predatory(my.name)
print(out)
}
