% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rqpois.R
\name{rqpois}
\alias{rqpois}
\title{Sampling of overdispersed Poisson data with constant overdispersion}
\usage{
rqpois(n, lambda, phi, offset = NULL)
}
\arguments{
\item{n}{defines the number of clusters (\eqn{i})}

\item{lambda}{defines the overall Poisson mean (\eqn{\lambda})}

\item{phi}{dispersion parameter (\eqn{\Phi})}

\item{offset}{defines the number of experimental units per cluster (\eqn{n_i})}
}
\value{
a data.frame containing the sampled observations and the offsets
}
\description{
\code{rqpois()} samples overdispersed Poisson data with constant overdispersion from
the negative-binomial distribution such that the quasi-Poisson assumption is fulfilled.
The following description of the sampling process is based on the parametrization
used by Gsteiger et al. 2013.
}
\details{
It is assumed that the dispersion parameter (\eqn{\Phi})
is constant for all \eqn{i=1, ... I} clusters, such that the variance becomes
\deqn{var(y_i)= \mu_i (1+\mu_i \kappa_i) = \Phi \mu_i}
For the sampling \eqn{\kappa_i} is defined as
\deqn{\kappa_i=(\Phi-1)/(\mu_i)}
where \eqn{\mu_i=n_i \lambda}, \eqn{a_i=1/\kappa_i} and \eqn{b_i=1/(\kappa_i \mu_i)}. Then, the Poisson means
for each cluster are sampled from the gamma distribution
\deqn{\lambda_i \sim Gamma(a_i, b_i)}
and the observations per cluster are sampled to be
\deqn{y_i \sim Pois(\lambda_i).}
Please note, that the quasi-Poisson assumption is not in contradiction with the
negative-binomial distribution if the data structure is defined by the number
of clusters only (which is the case here), rather than by a complex randomization structure.
}
\examples{
# set.seed(123)
qp_dat1 <- rqpois(n=10, lambda=50, phi=3)
qp_dat1

# set.seed(123)
qp_dat2 <- rqpois(n=3, lambda=50, phi=3)
qp_dat2


}
\references{
Gsteiger, S., Neuenschwander, B., Mercier, F. and Schmidli, H. (2013):
Using historical control information for the design and analysis of clinical
trials with overdispersed count data. Statistics in  Medicine, 32: 3609-3622.
\doi{10.1002/sim.5851}
}
