% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differences.R
\name{prec_riskdiff}
\alias{prec_riskdiff}
\title{Sample size or precision for risk difference}
\usage{
prec_riskdiff(
  p1,
  p2,
  n1 = NULL,
  conf.width = NULL,
  r = 1,
  conf.level = 0.95,
  method = c("newcombe", "mn", "ac", "wald"),
  ...
)
}
\arguments{
\item{p1}{risk among exposed.}

\item{p2}{risk among unexposed.}

\item{n1}{number of patients in exposed group.}

\item{conf.width}{precision (the full width of the confidence interval).}

\item{r}{allocation ratio (relative size of exposed and unexposed cohort
(\code{n1} / \code{n2})).}

\item{conf.level}{confidence level.}

\item{method}{Exactly one of \code{newcombe} (\emph{default}), \code{mn}
(Miettinen-Nurminen), \code{ac} (Agresti-Caffo), \code{wald}. Methods can
be abbreviated.}

\item{...}{other options to uniroot (e.g. \code{tol})}
}
\description{
\code{prec_riskdiff} returns the risk difference and the sample size or the
precision for the provided proportions.
}
\details{
Exactly one of the parameters \code{n1} or \code{conf.width} must be passed as NULL,
and that parameter is determined from the other.

Newcombe (\code{newcombe}) proposed a confidence interval based on the wilson
score method for the single proportion (see \link{prec_prop}). The confidence
interval without continuity correction is implemented from equation 10 in
Newcombe (1998).

Miettinen-Nurminen (\code{mn}) provide a closed from equation for the
restricted maximum likelihood estimate . The implementation is based on
code provided by Yongyi Min on
\url{http://users.stat.ufl.edu/~aa/cda/R/two-sample/R2/index.html}.

Agresti-Caffo (\code{ac}) confidence interval is based on the Wald confidence
interval, adding 1 success to each cell of the 2 x 2 table (see Agresti and
Caffo 2000).

\code{\link[stats]{uniroot}} is used to solve n for the newcombe, ac, and mn
method.
}
\examples{
# Validate Newcombe (1998)
prec_riskdiff(p1 = 56/70, p2 = 48/80, n1 = 70, r = 70/80, met = "newcombe")  # Table IIa
prec_riskdiff(p1 = 10/10, p2 = 0/10, n1 = 10, met = "newcombe")  # Table IIh

prec_riskdiff(p1 = c(56/70, 9/10, 6/7, 5/56),
              p2 = c(48/80, 3/10, 2/7, 0/29),
              n1 = c(70, 10, 7, 56),
              r = c(70/80, 1, 1, 56/29),
              method = "wald")

}
\references{
Agresti A (2003) \emph{Categorical Data Analysis}, Second Edition, Wiley
Series in Probability and Statistics,
\href{https://doi.org/10.1002/0471249688}{doi:10.1002/0471249688}.

Agresti A and Caffo B (2000) \emph{Simple and Effective Confidence Intervals
for Proportions and Differences of Proportions Result from Adding Two
Successes and Two Failures}, The American Statistician, 54(4):280-288.

Miettinen O and Nurminen M (1985) \emph{Comparative analysis of two rates},
Statistics in Medicine, 4:213-226.

Newcombe RG (1998) \emph{Interval estimation for the difference between
independent proportions: comparison of eleven methods}, Statistics in
Medicine, 17:873-890.

Fagerland MW, Lydersen S, and Laake P (2015). \emph{Recommended confidence
intervals for two independent binomial proportions}, Statistical methods in
medical research 24(2):224-254.
}
