% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esc_2024_conference_ptp.R
\name{calculate_esc_2024_fig_4_ptp}
\alias{calculate_esc_2024_fig_4_ptp}
\title{Calculate ESC 2024 PTP for obstructive CAD}
\usage{
calculate_esc_2024_fig_4_ptp(
  age,
  sex,
  chest_pain_type,
  have_dyspnoea,
  have_family_history,
  have_smoking_history,
  have_dyslipidemia,
  have_hypertension,
  have_diabetes,
  allow_na_symptom_score = TRUE,
  max_na_num_of_rf = 0,
  output = c("grouping", "numeric", "percentage")
)
}
\arguments{
\item{age}{Input integer value to indicate the age of the patient.}

\item{sex}{Input characters (female, male) to indicate the sex of the patient.
\itemize{
  \item female
  \item male
}}

\item{chest_pain_type}{Input characters (no chest pain, typical, atypical, nonanginal)
to indicate the chest pain characteristics of the patient.
\itemize{
  \item no chest pain stands for the patient having no chest pain.
  \item typical stands for the patient having typical chest pain.
  \item atypical stands for the patient having atypical chest pain.
  \item nonanginal stands for the patient having nonanginal or non-specific chest pain.
}}

\item{have_dyspnoea}{Input characters (no, yes) to indicate if the patient
only has dyspnoea symptoms.
\itemize{
  \item no stands for not having dyspnoea symptoms.
  \item yes stands for having dyspnoea symptoms.
}}

\item{have_family_history}{Input characters (no, yes) to indicate if the patient
has a family history of CAD.
\itemize{
  \item no stands for not having a family history of CAD.
  \item yes stands for having a family history of CAD.
}}

\item{have_smoking_history}{Input characters (no, yes) to indicate if the patient
has a smoking history (current or past smoker).
\itemize{
  \item no stands for not having a smoking history (non-smoker).
  \item yes stands for having a smoking history (current or past smoker).
}}

\item{have_dyslipidemia}{Input characters (no, yes) to indicate if the patient
has dyslipidemia.
\itemize{
  \item no stands for not having dyslipidemia.
  \item yes stands for having dyslipidemia.
}}

\item{have_hypertension}{Input characters (no, yes) to indicate if the patient
has hypertension.
\itemize{
  \item no stands for not having hypertension.
  \item yes stands for having hypertension.
}}

\item{have_diabetes}{Input characters (no, yes) to indicate if the patient
has diabetes.
\itemize{
  \item no stands for not having diabetes.
  \item yes stands for having diabetes.
}}

\item{allow_na_symptom_score}{A logical evaluating to \code{TRUE} or \code{FALSE} indicating whether we can
allow \code{chest_pain_type} or \code{have_dyspnoea} to be \code{NA} when calculating the score}

\item{max_na_num_of_rf}{Input integer 0 to 5 to indicate the maximum number of
missing risk factors to tolerate before outputting an \code{NA}.
Default: 0}

\item{output}{Input text to indicate the how pre-test
probability results be expressed
Default: c("grouping", "numeric", "percentage")
\itemize{
  \item grouping means the PTP will be expressed as Low, Intermediate and High.
  \itemize{
     \item very low if PTP is less than or equal to 5\%.
     \item low if PTP is in between 6\% to 15\%.
     \item moderate if PTP is more than 15\%.
  }
  \item numeric means the PTP will be expressed as an integer probability (0-100).
  \item percentage means the PTP will be expressed as percentage text (0-100\%).
}}
}
\value{
An integer, percentage or category representing the patient's PTP for obstructive CAD
based on the ESC 2024 guidelines.
See parameter option \code{output} for more information.
}
\description{
This function returns a patient's
pre-test Probability (PTP) of obstructive
coronary artery disease (CAD) based on the
European Society of Cardiology (ESC) 2024 guidelines.
}
\examples{
# 30 female with symptom score of 0 and 0 risk factors
calculate_esc_2024_fig_4_ptp(
  age = 30,
  sex = "female",
  chest_pain_type = "no chest pain",
  have_dyspnoea = "no",
  have_family_history = "no",
  have_smoking_history = "no",
  have_dyslipidemia = "no",
  have_hypertension = "no",
  have_diabetes = "no",
  allow_na_symptom_score = TRUE,
  max_na_num_of_rf = 0,
  output = "percentage"
)

}
