% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequence.R
\name{get_sequences}
\alias{get_sequences}
\title{Retrieves fasta sequences from NCBI nucleotide database.}
\usage{
get_sequences(gi, start = NULL, stop = NULL, simplify = TRUE,
  .parallel = FALSE, .progress = "none")
}
\arguments{
\item{gi}{the gi number of the sequence to retrieve}

\item{start}{start bases to retrieve, numbered beginning at 1.  If NULL the
beginning of the sequence.}

\item{stop}{stop bases to retrieve, numbered beginning at 1. if NULL the stop of
the sequence.}

\item{simplify}{simplify the FASTA headers to include only the genbank
accession.}

\item{.parallel}{if 'TRUE', perform in parallel, using parallel backend
provided by foreach}

\item{.progress}{name of the progress bar to use, see 'create_progress_bar'}
}
\value{
an DNAbin object.
}
\description{
Retrieves fasta sequences from NCBI nucleotide database.
}
\seealso{
\code{\link{DNAbin}}
}
