% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_locked_in_constraints.R
\name{add_locked_in_constraints}
\alias{add_locked_in_constraints}
\alias{add_locked_in_constraints,ConservationProblem,character-method}
\alias{add_locked_in_constraints,ConservationProblem,numeric-method}
\alias{add_locked_in_constraints,ConservationProblem,Raster-method}
\alias{add_locked_in_constraints,ConservationProblem,Spatial-method}
\alias{add_locked_in_constraints}
\alias{add_locked_in_constraints}
\alias{add_locked_in_constraints}
\alias{add_locked_in_constraints}
\title{Add locked in constraints}
\usage{
add_locked_in_constraints(x, locked_in)

\S4method{add_locked_in_constraints}{ConservationProblem,numeric}(x, locked_in)

\S4method{add_locked_in_constraints}{ConservationProblem,character}(x, locked_in)

\S4method{add_locked_in_constraints}{ConservationProblem,Spatial}(x, locked_in)

\S4method{add_locked_in_constraints}{ConservationProblem,Raster}(x, locked_in)
}
\arguments{
\item{x}{\code{\link{ConservationProblem-class}} object.}

\item{locked_in}{Object that determines which planning units that should be
locked in. See details for more information.}
}
\value{
\code{\link{ConservationProblem-class}} object.
}
\description{
Add constraints to ensure that they are prioritized in the solution.
For example, it may be desirable to lock in planning units that are
inside existing protected areas so that the solution fills in the gaps in the
existing reserve network. If specific planning units should be locked out
of a solution, use \code{\link{add_locked_out_constraints}}.
}
\details{
The locked in planning units can be specified in several
  different ways:

  \describe{

  \item{\code{integer}}{\code{vector} of indices pertaining to which
    planning units should be locked in.}

  \item{\code{character}}{column name in the attribute table values
    indicating if planning units should be locked in. This option is
    only available if the planning units in \code{x} are a
    \code{\link[sp]{Spatial-class}} object. The column in the attribute
    table should have \code{logical}  (i.e. \code{TRUE} or \code{FALSE})
    values indicating if the planning unit is to be locked in.}

  \item{\code{\link[raster]{Raster-class}} object}{planning units in \code{x}
    that intersect with cells in \code{y} are locked in. Specifically,
    only if the intersect with cells in \code{y} are that are not equal to
    zero or \code{NA}.}

  \item{\code{\link[sp]{Spatial-class}} object.}{planning units in \code{x}
    that spatially intersect with \code{locked_in} are locked in.}

 }
}
\examples{
# create basic problem
p1 <- problem(sim_pu_polygons, sim_features, "cost") \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(0.2)

# create problem with added locked in constraints using integers
p2 <- p1 \%>\% add_locked_in_constraints(which(sim_pu_polygons$locked_in))

# create problem with added locked in constraints using a field name
p3 <- p1 \%>\% add_locked_in_constraints("locked_in")

# create problem with added locked in constraints using raster data
p4 <- p1 \%>\% add_locked_in_constraints(sim_locked_in_raster)

# create problem with added locked in constraints using spatial polygons data
locked_in <- sim_pu_polygons[sim_pu_polygons$locked_in == 1, ]
p5 <- p1 \%>\% add_locked_in_constraints(locked_in)
\donttest{
# solve problems
s1 <- solve(p1)
s2 <- solve(p2)
s3 <- solve(p3)
s4 <- solve(p4)
s5 <- solve(p5)

# plot solutions
par(mfrow = c(3,2), mar = c(0, 0, 4.1, 0))
plot(s1, main = "none locked in")
plot(s1[s1$solution_1 == 1, ], col = "darkgreen", add = TRUE)

plot(s2, main = "locked in (integer input)")
plot(s2[s2$solution_1 == 1, ], col = "darkgreen", add = TRUE)

plot(s3, main = "locked in (character input)")
plot(s3[s3$solution_1 == 1, ], col = "darkgreen", add = TRUE)

plot(s4, main="locked in (raster input)")
plot(s4[s4$solution_1 == 1, ], col = "darkgreen", add = TRUE)

plot(s5, main="locked in (polygon input)")
plot(s5[s5$solution_1 == 1, ], col = "darkgreen", add = TRUE)
}

}
\seealso{
\code{\link{constraints}}.
}
