% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magrittr-operators.R
\name{\%>\%}
\alias{\%>\%}
\alias{pipe}
\title{Pipe operator}
\arguments{
\item{lhs, rhs}{An object and a function.}
}
\value{
An object.
}
\description{
This package uses the pipe operator (\verb{\\\%>\\\%}) to express nested code
as a series of imperative procedures.
}
\examples{
# set seed for reproducibility
set.seed(500)

# generate 100 random numbers and calculate the mean
mean(runif(100))

# reset the seed
set.seed(500)

# repeat the previous procedure but use the pipe operator instead of nesting
# function calls inside each other.
runif(100) \%>\% mean()

}
\seealso{
\code{\link[magrittr:pipe]{magrittr::\%>\%()}}, \code{\link[=tee]{tee()}}.
}
