% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marxan_boundary_data_to_matrix.R
\name{marxan_boundary_data_to_matrix}
\alias{marxan_boundary_data_to_matrix}
\title{Convert \emph{Marxan} boundary data to matrix format}
\usage{
marxan_boundary_data_to_matrix(x, data)
}
\arguments{
\item{x}{\code{\link[=problem]{problem()}} object that
contains planning unit and zone data to ensure that the argument to
\code{data} is converted correctly. This argument can be set to
\code{NULL} if checks are not required (not recommended).}

\item{data}{\code{data.frame} object with the columns \code{"id1"},
\code{"id2"}, and \code{"boundary"}.}
}
\value{
A \code{\link[Matrix:dgCMatrix-class]{Matrix::dgCMatrix}} sparse matrix object.
}
\description{
Convert a \code{data.frame} object containing \emph{Marxan} boundary data
to matrix format. This function is designed specifically for
boundary data (not connectivity data).
It ensures that the output matrix correctly specifies
symmetric spatial relationships between planning units.
}
\section{Notes}{

In earlier versions, the function could convert boundary data
that pertain to multiple zones. This is no longer possible, following
updates to streamline the package.
}

\examples{
# create example planning unit layer
pu_data <-
  matrix(1:3, nrow = 1) \%>\%
  terra::rast() \%>\%
  setNames("id") \%>\%
  terra::as.polygons() \%>\%
  sf::st_as_sf()

# plot planning units
plot(pu_data)

# manually create Marxan boundary data for these planning units following
# the Marxan boundary data format specification
bldf <- data.frame(
  id1 = c(1, 2, 3, 1, 2),
  id2 =c(1, 2, 3, 2, 3),
  boundary = c(3, 2, 3, 1, 1)
)

# print data
print(bldf)

# convert to boundary matrix format for use in prioritizr
m1 <- marxan_boundary_data_to_matrix(NULL, bldf)

# print converted matrix
## we can see that the values in bldf and m1 are different,
## this is because Marxan and prioritizr use different formats
## for storing boundary information
print(m1)

# automatically create boundary data for use in prioritizr,
# by using the boundary_matrix() function
m2 <- boundary_matrix(pu_data)

# print matrix
## we can see that the values in m1 and m2 are exactly the same,
## this is because marxan_boundary_data_to_matrix() automatically
## converts Marxan data to the same format as boundary_matrix()
print(m2)

}
