% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priorityelasticnet.R
\name{priorityelasticnet}
\alias{priorityelasticnet}
\title{Priority Elastic Net for High-Dimensional Data}
\usage{
priorityelasticnet(
  X,
  Y,
  weights = NULL,
  family = c("gaussian", "binomial", "cox", "multinomial"),
  alpha = 0.5,
  type.measure,
  blocks,
  max.coef = NULL,
  block1.penalization = TRUE,
  lambda.type = "lambda.min",
  standardize = TRUE,
  nfolds = 10,
  foldid = NULL,
  cvoffset = FALSE,
  cvoffsetnfolds = 10,
  mcontrol = missing.control(),
  scale.y = FALSE,
  return.x = TRUE,
  adaptive = FALSE,
  initial_global_weight = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{X}{A numeric matrix of predictors.}

\item{Y}{A response vector. For family = "multinomial", Y should be a factor with more than two levels.}

\item{weights}{Optional observation weights. Default is NULL.}

\item{family}{A character string specifying the model type. Options are "gaussian", "binomial", "cox", and "multinomial". Default is "gaussian".}

\item{alpha}{The elastic net mixing parameter, with \eqn{0 \le \alpha \le 1}. The penalty is defined as \eqn{(1-\alpha)/2||\beta||_2^2 + \alpha||\beta||_1}. Default is 1.}

\item{type.measure}{Loss function for cross-validation. Options are "mse", "deviance", "class", "auc". Default depends on the family.}

\item{blocks}{A list where each element is a vector of indices indicating the predictors in that block.}

\item{max.coef}{A numeric vector specifying the maximum number of non-zero coefficients allowed in each block. Default is NULL, meaning no limit.}

\item{block1.penalization}{Logical. If FALSE, the first block will not be penalized. Default is TRUE.}

\item{lambda.type}{Type of lambda to select. Options are "lambda.min" or "lambda.1se". Default is "lambda.min".}

\item{standardize}{Logical flag for variable standardization, prior to fitting the model. Default is TRUE.}

\item{nfolds}{Number of folds for cross-validation. Default is 10.}

\item{foldid}{Optional vector of values between 1 and \code{nfolds} identifying what fold each observation is in. Default is NULL.}

\item{cvoffset}{Logical. If TRUE, a cross-validated offset is used. Default is FALSE.}

\item{cvoffsetnfolds}{Number of folds for cross-validation of the offset. Default is 10.}

\item{mcontrol}{Control parameters for handling missing data. Default is \code{missing.control()}.}

\item{scale.y}{Logical. If TRUE, the response variable Y is scaled. Default is FALSE.}

\item{return.x}{Logical. If TRUE, the function returns the input matrix X. Default is TRUE.}

\item{adaptive}{Logical. If \code{TRUE}, the adaptive elastic net is used, where penalties are adjusted based on the importance of the coefficients from an initial model fit. Default is \code{FALSE}.}

\item{initial_global_weight}{Logical. If TRUE (the default), global initial weights will be calculated based on all predictors. If FALSE, initial weights will be calculated separately for each block.}

\item{verbose}{Logical. If TRUE prints detailed logs of the process. Default is FALSE.}

\item{...}{Additional arguments to be passed to \code{cv.glmnet}.}
}
\value{
A list with the following components:
\item{lambda.ind}{Indices of the selected lambda values.}
\item{lambda.type}{Type of lambda used.}
\item{lambda.min}{Selected lambda values.}
\item{min.cvm}{Cross-validated mean squared error for each block.}
\item{nzero}{Number of non-zero coefficients for each block.}
\item{glmnet.fit}{Fitted \code{glmnet} objects for each block.}
\item{name}{Name of the model.}
\item{block1unpen}{Fitted model for the unpenalized first block, if applicable.}
\item{coefficients}{Coefficients of the fitted models.}
\item{call}{The function call.}
\item{X}{The input matrix X, if \code{return.x} is TRUE.}
\item{missing.data}{Logical vector indicating missing data.}
\item{imputation.models}{Imputation models used, if applicable.}
\item{blocks.used.for.imputation}{Blocks used for imputation, if applicable.}
\item{missingness.pattern}{Pattern of missing data, if applicable.}
\item{y.scale.param}{Parameters for scaling Y, if applicable.}
\item{blocks}{The input blocks.}
\item{mcontrol}{Control parameters for handling missing data.}
\item{family}{The model family.}
\item{dim.x}{Dimensions of the input matrix X.}
}
\description{
This function performs penalized regression analysis using the elastic net method, tailored for high-dimensional data with a known group structure. It also includes an optional feature to launch a Shiny application for model evaluation with weighted threshold optimization.
}
\note{
Ensure that \code{glmnet} version >= 2.0.13 is installed. The function does not support single missing values within a block.
}
\examples{
\donttest{

  # Simulation of multinomial data:
  set.seed(123)
  n <- 100
  p <- 50
  k <- 3
  x <- matrix(rnorm(n * p), n, p)
  y <- sample(1:k, n, replace = TRUE)
  y <- factor(y)
  blocks <- list(bp1 = 1:10, bp2 = 11:30, bp3 = 31:50)
  
  # Run priorityelasticnet:
  fit <- priorityelasticnet(x, y, family = "multinomial", alpha = 0.5, 
                     type.measure = "class", blocks = blocks,
                     block1.penalization = TRUE, lambda.type = "lambda.min", 
                     standardize = TRUE, nfolds = 5, 
                     adaptive = FALSE)
                     
   fit$coefficients
}
}
