% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/highlight.R
\name{prismjs}
\alias{prismjs}
\alias{prism_highlight_text}
\alias{prism_highlight_document}
\alias{prism_process_xmldoc}
\alias{prism_languages}
\title{Prism Syntax Highlighter}
\usage{
prism_highlight_text(txt, language = "r")

prism_highlight_document(
  input,
  output = NULL,
  include_css = FALSE,
  preview = interactive()
)

prism_process_xmldoc(doc)

prism_languages()
}
\arguments{
\item{txt}{string with code that you want to highlight}

\item{language}{the language that \code{txt} is in, one of \code{prism_languages()}.}

\item{input}{literal html string, connection, or file path, passed to \link[xml2:read_xml]{xml2::read_html}}

\item{output}{path to file or connection to write to, passed to \link[xml2:write_xml]{xml2::write_html}. Set
\code{NULL} to return the entire output document as a character string.}

\item{include_css}{insert the Prism css style (with the default theme) into the html header.}

\item{preview}{opens the generated output html in a browser}

\item{doc}{an \link[xml2:read_xml]{xml2 document} that will be modified in place
such that all \verb{<code class="language-xyz">} elements are replaced with highlighted html.}
}
\value{
html with classes that can be colorized using a prims stylesheet
}
\description{
The \code{prism_highlight_text} function takes a string with a single code snippet
and returns an html fragment with syntax classes. This html gets colorized by
the \href{https://cdnjs.com/libraries/prism}{prism stylesheet} when both are inserted
in an HTML document.
}
\details{
The function \code{prism_highlight_document} processes an entire HTML document,
similar to how PrismJS works in a browser. It automatically finds all
\verb{<code class="language-xyz">} elements in the document and substitutes these
with highlighted html elements. Again, CSS is needed to actually colorize the
html, you can use \code{include_css} to automatically inject the CSS in the html
header if your input document does not have this yet.
}
\examples{
html <- prism_highlight_text('p { color: red }', language = 'css')
cat(html)
prism_languages()
}
