% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xor.R
\name{xor}
\alias{xor}
\title{Check for exclusiveness of two activities}
\usage{
xor(activity_a, activity_b)
}
\arguments{
\item{activity_a}{Activity A. A character vector of length one. This should be an activity of the event log supplied to  `check_rule`.}

\item{activity_b}{Activity B. A character vector of length one. This should be an activity of the event log supplied to  `check_rule`.}
}
\description{
If activity A exists, Activity B should not exist, and vice versa.
}
\examples{
library(bupaR)
library(eventdataR)

# A patient should not receive both an X-Ray and MRI Scan
patients \%>\%
check_rule(xor("X-Ray","MRI SCAN"))
}
\seealso{
Other Declarative Rules: \code{\link{absent}},
  \code{\link{and}}, \code{\link{contains_between}},
  \code{\link{contains_exactly}}, \code{\link{contains}},
  \code{\link{ends}}, \code{\link{precedence}},
  \code{\link{responded_existence}},
  \code{\link{response}}, \code{\link{starts}},
  \code{\link{succession}}
}
